#ifndef ALTSYNCTHREAD_H
#define ALTSYNCTHREAD_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSyncThread.h 551 2007-11-10 02:21:29Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altSyncThread.h
 * \brief   thread sync
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>

#ifdef ALT_LINUX
  #include <pthread.h>
#endif

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Thread Sync
///
class altSyncThread
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altSyncThread();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altSyncThread();

  ///
  /// \brief  Begin Lock
  ///
  LIBALT_API void BeginLock() const;

  ///
  /// \brief  End Lock
  ///
  LIBALT_API void EndLock() const;

  ///
  /// \brief  Wait Signal
  ///
  /// \param  dwTimeout   [I ] timeout(msec) (default value is no timeout)
  ///
  void WaitSignal(DWORD dwTimeout = INFINITE) const;

	///
	/// \brief	Set Signal
	///
	void SetSignal() const;

private:
#ifdef ALT_WIN
  mutable CRITICAL_SECTION  m_oCriticalSection;
  mutable HANDLE            m_oEvent;
#else
  mutable pthread_mutex_t   m_oMutex;
  mutable pthread_cond_t    m_oCond;
#endif
  mutable altBool           m_bLock;
};

#endif  // ALTSYNCTHREAD_H

