#ifndef ALTMYSQLPREPAREDSTATEMENT_H
#define ALTMYSQLPREPAREDSTATEMENT_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altMySQLPreparedStatement.h 333 2007-10-01 05:08:18Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altMySQLPreparedStatement.h
 * \brief   MySQL Prepared Statement Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altDB/altPreparedStatement.h>
#include <altDB/altMySQLStmt.h>
#include <altDB/altMySQLRes.h>
#include <altDB/altMySQL.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  MySQL Prepared Statement
///
class altMySQLPreparedStatement : public altPreparedStatement
{
public:
  ///
  /// \brief  Constructor
  ///
  /// \param  oSQL  [I ] SQL
  ///
  LIBALT_API altMySQLPreparedStatement(const altSQL & oSQL, altMySQL & oMySQL);

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altMySQLPreparedStatement();

  ///
  /// \brief  Prepare
  ///
  /// \param  oMySQL  [I ] MySQL Object
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_SQL       SQL Error
  ///
  LIBALT_API alt_t Prepare();

  ///
  /// \brief  Execute
  ///
  /// \param  oResultSet  [ O] Result Set
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_SQL       SQL Error
  ///
  LIBALT_API alt_t ExcecuteSQL(altDBResultSet & oResultSet);

  ///
  /// \brief  Execute
  ///
  /// \param  pAffectedRow  [ O] Affected Count
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_SQL       SQL Error
  ///
  LIBALT_API alt_t ExcecuteSQL(altULongLong * pAffectedRow);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altChar nVal, const altBool bIsNULL = false);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altByte nVal, const altBool bIsNULL = false);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altShort nVal, const altBool bIsNULL = false);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altUShort nVal, const altBool bIsNULL = false);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altInt nVal, const altBool bIsNULL = false);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altUInt nVal, const altBool bIsNULL = false);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altLong nVal, const altBool bIsNULL = false);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altULong nVal, const altBool bIsNULL = false);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altLongLong nVal, const altBool bIsNULL = false);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altULongLong nVal, const altBool bIsNULL = false);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altFloat nVal, const altBool bIsNULL = false);

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altDouble nVal, const altBool bIsNULL = false);

  ///
  /// \brief  Add Value
  ///
  /// \param  sVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altStr & sVal, const altBool bIsNULL = false);

  ///
  /// \brief  Add Value
  ///
  /// \param  oVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API alt_t Add(const altDateTime & oVal, const altBool bIsNULL = false);

  ///
  /// \brief  Clear Query Parameter
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t Clear();

  ///
  /// \brief  Get SQL String
  ///
  /// \return SQL String
  ///
  LIBALT_API altStr toString() const;

private:
  ///
  /// \brief	Extend Query Buffer
  ///
  /// \return ALT_S_SUCCESS	Success
  /// \return ALT_E_NOMEM		Out of Memory
  ///
  alt_t ExntendQueryBuffer();

  ///
  /// \brief	Bind Query Buffer
  ///
  /// \return ALT_S_SUCCESS Success
  /// \return ALT_E_SQL     SQL Error
  ///
  alt_t BindParam();

  altMySQL        m_oMySQL;
  altMySQLStmt    m_oMySQLStmt;
  
	MYSQL_BIND *    m_pQueryBind;
	my_bool *       m_pQueryIsNULL;
	DWORD *         m_pQueryLength;
	altUInt         m_nParamCount;

  altMySQLRes     m_oMetaResult;
	MYSQL_BIND *    m_pResultBind;
	my_bool *       m_pResultIsNULL;
	DWORD *         m_pResultLength;
	my_bool *       m_pResultError;
	altUInt         m_nResultColumnCount;
};

#endif

