#ifndef ALTTEXTBOX_H
#define ALTTEXTBOX_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altTextBox.h 793 2008-01-17 08:27:39Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altTextBox.h
 * \brief   Text Box Component
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_WIN
#include <altDX/Component/altTextBoxListener.h>
#include <altDX/Component/altLabel.h>
#include <altDX/altIMEComponent.h>
#include <time.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef std::vector<altTextBoxListener *> altTextInputListenerList;

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Text Box
///
class altTextBox : public altLabel, public altIMEComponent, public altKeyEventListener
{
public:
  ///
  /// \brief  Constructor
  ///
  /// \param  x [I ] X
  /// \param  y [I ] Y
  /// \param  h [I ] Height
  /// \param  w [I ] Width
  ///
  LIBALT_API altTextBox(const altLong x, const altLong y, const altLong h, const altLong w);

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altTextBox();

  ///
  /// \brief  Render
  ///
  /// \param  pDevice  [I ] D3D Device
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API virtual alt_t Render(IDirect3DDevice9 * pDevice);

  ///
  /// \brief  On focus
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API virtual alt_t OnFocus();

  ///
  /// \brief  Off focus
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API virtual alt_t OffFocus();

  ///
  /// \brief  Input IME word
  ///
  /// \param  sData [I ] IME word
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API virtual alt_t InputIMEWord(const altWStr & sData);

  ///
  /// \brief  Send IME word
  ///
  /// \param  sData [I ] IME word
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API virtual alt_t SendIMEWord(const altWStr & sData);

  ///
  /// \brief  Listen key down event
  ///
  /// \param  oEvent  [I ] Event
  /// \param  nKey    [I ] Key
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API virtual alt_t OnKeyDown(const altEvent & oEvent, const altUInt nKey);
  
  ///
  /// \brief  Window Procedure
  ///
  /// \param  hwnd    [I ] Window handle
  /// \param  msg     [I ] message
  /// \param  wParam  [I ] parameter
  /// \param  lParam  [I ] parameter
  ///
  LIBALT_API virtual LRESULT WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

  ///
  /// \brief  Add input listener
  ///
  /// \param  pListener [I ] Input listener
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  /// \return ALT_E_INVAL   invalid paramter
  ///
  LIBALT_API alt_t AddListener(altTextBoxListener * pListener);

protected:
  altWStr                   m_sInputBuffer;     ///< Input string buffer
  altWStr                   m_sInput;           ///< Input string

private:
  altTextInputListenerList  m_oInputListener;   ///< Text input listener list
  clock_t                   m_nLastTime;        ///< Cursor last time
};

#endif
#endif
