#ifndef ALTTEXTBOXLISTENER_H
#define ALTTEXTBOXLISTENER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altTextBoxListener.h 774 2007-12-20 04:24:58Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altTextBoxListener.h
 * \brief   Text Box Listener
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_WIN
#include <altBase/altWStr.h>
#include <altBase/altLog.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Text Box Listener
///
class altTextBoxListener
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altTextBoxListener();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altTextBoxListener();

  ///
  /// \brief  On input call back
  ///
  /// \param  sMessage  [I ] Message
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API virtual alt_t OnInput(const altWStr & sMessage) = 0;
};

#endif
#endif
