#ifndef ALTFONTMANAGER_H
#define ALTFONTMANAGER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altFontManager.h 778 2008-01-07 03:57:12Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altFontManager.h
 * \brief   DirectX 2D Font Manager
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_WIN
#include <altDX/altFont.h>
#include <altBase/altStr.h>

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
#define aiFontManager altFontManager::GetInstance()   ///< Get font manager instance

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef std::map<altStr, altFont *> altFontMap;   ///< Font Container

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  DirectX 2D Font Manager
///
class altFontManager : public altSingleton<altFontManager>
{
friend class altSingleton<altFontManager>;
private:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altFontManager();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altFontManager();

public:
  ///
  /// \brief  Create new font
  ///
  /// \param  h         [I ] Font Height
  /// \param  w         [I ] Font Width
  /// \param  nWeight   [I ] Font weight
  /// \param  bItalic   [I ] Italic or not
  /// \param  nCharSet  [I ] Charcter set
  /// \param  sFaceName [I ] Font face name
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t CreateFont(const altStr & sFontName, const altInt h, const altInt w = 0, const altUInt nWeight = FW_NORMAL, const altBool bItalic = false, const BYTE nCharSet = SHIFTJIS_CHARSET, const altWStr & sFaceName = (wchar_t *)_T("lro SVbN"));

  ///
  /// \brief  Get font
  ///
  /// \param  sFontName [I ] Font name
  ///
  /// \return Pointer of font
  ///
  LIBALT_API altFont * GetFont(const altStr & sFontName);

  ///
  /// \brief  Get altFontManager Instance
  ///
  /// \return altDX Instance
  ///
  LIBALT_API static altFontManager & GetInstance();

  ///
  /// \brief  Delete Instance
  ///
  LIBALT_API static void DeleteInstance();

private:
  altFontMap  m_oFontMap;
};

#endif
#endif
