#ifndef ALTQUE_H
#define ALTQUE_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altQue.h 461 2007-10-28 16:30:05Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altQue.h
 * \brief   Queue
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altLog.h>
#include <altBase/altStatus.h>
#include <altBase/altUncopyable.h>
#include <altBase/altSyncThread.h>

#include <vector>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Que Class
///
template <class T>
class altQue : public altBase, private altUncopyable, public altSyncThread
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altQue()
  {
  }

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altQue()
  {
  }

  ///
  /// \brief  Push to first position
  ///
  /// \param  oData [I ] Data
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t Push(const T & oData)
  {
    BeginLock();
    m_oContainer.insert (m_oContainer.begin(), oData);
    EndLock();
    ALT_RET (ALT_S_SUCCESS);
  }

  ///
  /// \brief  Pop from last position
  ///
  /// \param  oData [ O] Data
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_S_NOT_FOUND not data
  ///
  LIBALT_API alt_t Pop(T & oData)
  {
    BeginLock();
    alt_t status = ALT_S_SUCCESS;
    if (! m_oContainer.empty()) {
      oData = m_oContainer.back();
      m_oContainer.pop_back();
    }
    else {
      status = ALT_S_NOT_FOUND;
    }
    EndLock();
    ALT_RET (status);
  }

  ///
  /// \brief  Check Is empty or not
  ///
  /// \return true  empty
  /// \return false not empty
  ///
  LIBALT_API altBool Empty()
  {
    BeginLock();
    altBool bEmpty = m_oContainer.empty();
    EndLock();
    return bEmpty;
  }

  ///
  /// \brief Get Size
  ///
  /// \return size
  ///
  LIBALT_API altUInt Size()
  {
    return static_cast<altUInt>(m_oContainer.size());
  }

protected:
  std::vector<T> m_oContainer;
};
#endif  //ALTQUE_H
