#ifndef ALTNETPACKET_H
#define ALTNETPACKET_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNETPacket.h 646 2007-11-16 11:04:52Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altNETPacket.h
 * \brief   Network Packet Data Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNet/altNETConnection.h>
#include <altBase/altCharPtr.h>
#include <altBase/altLog.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
class altNETConnection;
typedef const altNETConnection      altCNETConnection;      ///< const altNETConnection
typedef altPtr<altCNETConnection>   altCNETConnectionPtr;   ///< pointer of const altNETConnection

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Network Packet Data Class
///
class altNETPacket : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altNETPacket();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altNETPacket();

  ///
  /// \brief  Set Data
  ///
  /// \param  pNETConnection  [I ] NET Connection
  /// \param  pData           [I ] network data
  /// \param  nSize           [I ] data size
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  /// \return ALT_E_INVAL   invalid paramter
  ///
  LIBALT_API alt_t Set(const altCNETConnectionPtr & pNETConnection, const altCharPtr & pData, const altUInt nSize);

  ///
  /// \brief  Get Data
  ///
  /// \param  pNETConnection  [ O] NET Connection
  /// \param  pData           [ O] network data
  /// \param  nSize           [ O] data size
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t Get(altCNETConnectionPtr & pNETConnection, altCharPtr & pData, altUInt & nSize);

protected:
  altCharPtr                      m_pData;
  altUInt                         m_nSize;
  altPtr<const altNETConnection>  m_pConnection;
};
#endif  //ALTPACKET_H
