#ifndef ALTSOCKETADDRESS_H
#define ALTSOCKETADDRESS_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSocketAddress.h 139 2007-05-20 05:42:30Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altSocketAddress.h
 * \brief   Socket Address
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNet/altNetCommon.h>
#include <altBase/altLog.h>
#include <altBase/altStatus.h>
#include <altBase/altBase.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/


/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Socket Address Class
///
class altSocketAddress : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altSocketAddress();

  ///
  /// \brief  Constructor
  ///
  /// \param  oAddr     [I ] Socket Address
  /// \param  nAddrLen  [I ] Socket Address Length
  ///
  LIBALT_API altSocketAddress(const SOCKADDR & oAddr, const altUInt nAddrLen);

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altSocketAddress();

  ///
  /// \brief  Get Socket Address
  ///
  /// \return Socket Address
  ///
  LIBALT_API const SOCKADDR & GetAddr() const;

  ///
  /// \brief  Get Socket Address Length
  ///
  /// \return Socket Address Length
  ///
  LIBALT_API altUInt GetAddrLen() const;

  ///
  /// \brief  Get Pointer of Socket Address
  ///
  /// \return Pointer of Socket Address
  ///
  LIBALT_API const SOCKADDR * GetAddrPtr() const;

protected:
  SOCKADDR    m_oAddr;
  altUInt     m_nAddrLen;
};
#endif  //ALTSOCKETADDRESS_H
