#ifndef LIBALT_H
#define LIBALT_H
/*--------------------------------------------------------------------------*

   Alternative Library

  $Id: libalt.h 773 2007-12-19 22:00:50Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    libalt.h
 * \brief   Alternative Library Header
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altRuntime.h>
#include <altBase/altSignal.h>
#include <altBase/altCharPtr.h>
#include <altBase/altMemManager.h>
#include <altBase/altMem.h>
#include <altBase/altLog.h>
#include <altBase/altStr.h>
#include <altBase/altLoopThread.h>
#include <altBase/altThread.h>
#include <altBase/altBaseMem.h>
#include <altBase/altSingleton.h>
#include <altBase/altUncopyable.h>
#include <altBase/altSyncThread.h>
#include <altBase/altUtil.h>
#include <altBase/altBase.h>

#include <altMisc/altTimer.h>
#include <altMisc/altMiscUtil.h>
#include <altMisc/altBlowFish.h>
#include <altMisc/altBzip2.h>
#include <altMisc/altProperty.h>
#include <altMisc/altSHA1.h>
#include <altMisc/altMD5.h>
#include <altMisc/altMemLogger.h>
#include <altMisc/altFile.h>
#include <altMisc/altQue.h>

#include <altNet/altTCPServer.h>
#include <altNet/altTCPClient.h>
#include <altNet/altSSLServer.h>
#include <altNet/altSSLClient.h>

#include <altDB/altDBConnection.h>
#include <altDB/altDBConnectionPtr.h>
#include <altDB/altDBManager.h>
#include <altDB/altDBResultSet.h>
#include <altDB/altPreparedStatement.h>
#include <altDB/altSQL.h>
#include <altDB/altSQLLoader.h>

#include <altDB/altMySQL.h>

#ifdef ALT_WIN
  #include <altDX/altDX.h>
  #include <altDX/altDXInput.h>
  #include <altDX/alt2DQuad.h>
  #include <altDX/altComponent.h>
  #include <altDX/altIME.h>
  #include <altDX/altIMEComponent.h>
  #include <altDX/altMouse.h>
  #include <altDX/altPolygon.h>
  #include <altDX/altXFile.h>
  #include <altDX/altLight.h>
  #include <altDX/altFontManager.h>
  #include <altDX/Component/altLabel.h>
  #include <altDX/Component/altTextBox.h>
#endif

#endif  //LIBALT_H
