#!/bin/sh
#--------------------------------------------------------------------------
#
#   Alternative Library
#
#  $Id: build.sh 595 2007-11-13 23:02:48Z nekosys $
#
#  Copyright (C) 2007 NEKO SYSTEM
# 
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#---------------------------------------------------------------------------
function clean()
{
  rm -f debug/*.o
  rm -f libalt/debug/*.o
  rm -f test/debug/*.o
  rm -f test_echo_server/debug/*.o
  rm -f debug/*
  rm -f release/*.o
  rm -f libalt/release/*.o
  rm -f test/release/*.o
  rm -f test_echo_server/release/*.o
  rm -f release/*
}

function make_obj_debug()
{
  cat ../Makefile.header.debug > Makefile.debug
  cat Makefile.footer >> Makefile.debug
  make -f Makefile.debug
}

function make_obj_release()
{
  cat ../Makefile.header.release > Makefile.release
  cat Makefile.footer >> Makefile.release
  make -f Makefile.release 
}

function build()
{
  # build library
  cd libalt/altBase
  make_obj_debug;
  make_obj_release;
  cd ..

  cd altMisc
  make_obj_debug;
  make_obj_release;
  cd ..

  cd altNet
  make_obj_debug;
  make_obj_release;
  cd ..

  cd altDB
  make_obj_debug;
  make_obj_release;
  cd ..

  make_obj_debug;
  make_obj_release;
  cd ..

  # build test exe
  cd test/altBase
  make -f Makefile.debug
  make -f Makefile.release
  cd ..

  make -f Makefile.debug
  make -f Makefile.release
  cd ..

  # build echo server
  cd test_echo_server
  make -f Makefile.debug
  make -f Makefile.release
  cd ..

  # build echo client
  cd test_echo_client
  make -f Makefile.debug
  make -f Makefile.release
  cd ..

  # build ssl server
  cd ssl_echo_server
  make -f Makefile.debug
  make -f Makefile.release
  cd ..

  # build ssl client
  cd ssl_echo_client
  make -f Makefile.debug
  make -f Makefile.release
  cd ..
}

function check()
{
  if [ ! -f lib/test.exe ]; then
    build;
  fi
  cd debug
  gdb ./test.exe
}

if [ "$1" = "clean" ]; then
  clean;
elif [ "$1" = "rebuild" ]; then
  clean;
  build;
elif [ "$1" = "check" ]; then
  check;
else
  build;
fi
