/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altCharPtr.cpp 718 2007-11-23 14:58:14Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altCharPtr.cpp
 * \brief   Char Pointer class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altCharPtr.h"
#include "altBase/altStatus.h"

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altCharPtr::altCharPtr()
{
  m_bInherited = true;
}

///
/// \brief  Constructor
///
/// \param  p [I ] Data
///
LIBALT_API altCharPtr::altCharPtr(altChar * p) ALT_THROWS (alt_t)
{
  m_bInherited = true;
  try {
    (* this) = p;
  }
  catch (alt_t e) {
    ALT_LOG (e);
    throw e;
  }
}

///
/// \brief  Constructor
///
/// \param  p [I ] Data
///
LIBALT_API altCharPtr::altCharPtr(const altCharPtr & p)
{
  m_bInherited = true;
  (* this) = p.m_pPtr;
}

///
/// \brief  Destructor
///
LIBALT_API altCharPtr::~altCharPtr()
{
  oSync.BeginLock();
  oPtrMap[m_pPtr] = oPtrMap[m_pPtr] - 1;
  if (oPtrMap[m_pPtr] == 0) {
    ALT_FREE (m_pPtr);
  }
  oSync.EndLock();
};

///
/// \brief  Cast altChar *
///
/// \return Pointer
///
LIBALT_API altCharPtr::operator altChar * () const
{
  return (m_pPtr);
}

///
/// \brief  Cast altByte *
///
/// \return Pointer
///
LIBALT_API altCharPtr::operator altByte * () const
{
  return (altByte *)(m_pPtr);
}

///
/// \brief  = operator
///
/// \param  pPtr  [I ] Pointer of altChar
///
/// \return Pointer of altChar
///
LIBALT_API altChar * altCharPtr::operator = (altChar * pPtr) ALT_THROWS (alt_t)
{
  oSync.BeginLock();
  
  if (pPtr != NULL) {
    if (altMemValidate (pPtr) == false) {
      ALT_LOG (ALT_E_INVAL);
      oSync.EndLock();
      throw (ALT_E_INVAL);
    }
  }

  if (m_pPtr != NULL) {
    oPtrMap[m_pPtr] = oPtrMap[m_pPtr] - 1;
    if (oPtrMap[m_pPtr] == 0) {
      ALT_FREE (m_pPtr);
    }
  }
  m_pPtr = pPtr;
  if (m_pPtr != NULL) {
    oPtrMap[m_pPtr] = oPtrMap[m_pPtr] + 1;
  }
  oSync.EndLock();
  return (m_pPtr);
}

///
/// \brief  = operator
///
/// \param  pPtr  [I ] Pointer of altByte
///
/// \return Pointer of altByte
///
LIBALT_API altByte * altCharPtr::operator = (altByte * pPtr) ALT_THROWS (alt_t)
{
  return (altByte *)(this->operator = ((altChar *)pPtr));
}
