/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSignal.cpp 558 2007-11-10 04:16:15Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altSignal.cpp
 * \brief   Signal
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altSignal.h"
#ifdef ALT_LINUX
#include "altStr.h"
#include <errno.h>

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altSignal::altSignal()
{
}

///
/// \brief  Destructor
///
LIBALT_API altSignal::~altSignal()
{
}

///
/// \brief  Signal block
///
/// \param  nSignal [I ] Signal Number
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
LIBALT_API alt_t altSignal::Block(altInt nSignal)
{
  struct sigaction  oAction;
  struct sigaction  oOldAction;

  memset (& oAction, 0x00, sizeof (oOldAction));
  memset (& oOldAction, 0x00, sizeof (oOldAction));

  oAction.sa_handler = altSignal::BlockHandler;

  altInt  nRet = sigaction (nSignal, & oAction, & oOldAction);
  if (nRet < 0) {
    altInt  nErrNo = errno;
    altStr  sBuf;
    ALT_RET_P (ALT_E_ERROR, sBuf.Format ("%d:%s", nErrNo, strerror (nErrNo)));
  }

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Signal block handler
///
/// \param  nSignal [I ] Signal number
///
LIBALT_API void altSignal::BlockHandler(int nSignal)
{
}

#endif
