#ifndef ALTSINGLETON_H
#define ALTSINGLETON_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSingleton.h 589 2007-11-13 08:12:22Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altSingleton.h
 * \brief   Singleton Base Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altBase.h>
#include <altBase/altSyncThread.h>
#include <altBase/altUncopyable.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Singleton Base
///
template <typename T>
class altSingleton : public altBase, private altUncopyable
{
protected:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altSingleton(){};
  
  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altSingleton(){};

public:
  ///
  /// \brief	Get instance
  ///
  /// \return instance
  ///
	LIBALT_API static T & GetInstance()
  {
    if (pInstance == NULL) {
      oSyncThread.BeginLock();
      if (pInstance == NULL) {
        pInstance = new T();
      }
      oSyncThread.EndLock();
    }
    return (* pInstance);
  };

  ///
  /// \brief  Delete instance
  ///
  LIBALT_API static void DeleteInstance()
  {
    if (pInstance != NULL) {
      delete pInstance;
      pInstance = NULL;
    }
  };

protected:
	static T *		          pInstance;	    ///< instance
  static altSyncThread    oSyncThread;    ///< sync thread
};

template<typename T> T *           altSingleton<T>::pInstance = NULL;  ///< instance
template<typename T> altSyncThread altSingleton<T>::oSyncThread;       ///< sync thread

#endif  // ALTSINGLETON_H

