/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altThread.cpp 119 2007-05-17 11:21:38Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altThread.cpp
 * \brief   thread
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altThread.h"

#ifdef ALT_WIN
  #include <process.h>
#else
  #include <pthread.h>
#endif

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altThread::altThread()
{
}

///
/// \brief  Destructor
///
LIBALT_API altThread::~altThread()
{
}

///
/// \brief  Start thread
///
LIBALT_API void altThread::Start(altThreadFunc pFunc, void * pParam)
{
#ifdef ALT_WIN
  _beginthread (pFunc, 0, pParam);
#else
  pthread_t oThread;
  altInt nRet = pthread_create (& oThread, NULL, pFunc, pParam);
  if (nRet != 0) {
    // error
  }
#endif
}

