#ifndef ALTTHREAD_H
#define ALTTHREAD_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altThread.h 117 2007-05-16 22:49:42Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altThread.h
 * \brief   thread
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altBase.h>
#include <altBase/altUncopyable.h>

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
#ifdef ALT_WIN
  #define ALT_THREAD  void
#else
  #define ALT_THREAD  void *
#endif

#ifdef ALT_WIN
  #define ALT_THREAD_END(p) return
#else
  #define ALT_THREAD_END(p) return (p)
#endif

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef ALT_THREAD (* altThreadFunc)(void *);

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Thread
///
class altThread : public altBase, private altUncopyable
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altThread();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altThread();

  ///
  /// \brief  Start thread
  ///
  /// \param  pFunc   [I ] thread funciton
  /// \param  pParam  [I ] thread function parameter
  ///
  LIBALT_API virtual void Start(altThreadFunc pFunc, void * pParam);
};

#endif  // ALTTHREAD_H

