#ifndef ALTUNCOPYABLE_H
#define ALTUNCOPYABLE_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altUncopyable.h 69 2007-05-12 05:02:32Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altUncopyable.h
 * \brief   Uncopyable Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Uncopyable Class
///
class altUncopyable
{
protected:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altUncopyable(){};
  
  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altUncopyable(){};

private:
  ///
  /// \brief  Copy Constructor
  ///
  LIBALT_API altUncopyable(const altUncopyable & o);

  ///
  /// \brief  Copy Constructor
  ///
  LIBALT_API altUncopyable & operator = (const altUncopyable & o);
};

#endif  // ALTUNCOPYABLE_H
