#ifndef ALTUTIL_H
#define ALTUTIL_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altUtil.h 779 2008-01-07 09:06:21Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altUtil.h
 * \brief   Utility Function
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>

#include <stdarg.h>

/*----------------------------------------------------------------*
 * Function Declare
 *----------------------------------------------------------------*/

/**
 * \brief copy string
 *
 * \param pDst  [ O] output
 * \param pSrc  [I ] source string
 * \param nSize [I ] string size
 */
LIBALT_API void altStrncpy (
  altChar *       pDst,
  const altChar * pSrc,
  const altUInt   nSize
);


/**
 * \brief add string
 *
 * \param pDst      [ O] output
 * \param nDstSize  [I ] output buffer size
 * \param pSrc      [I ] source string
 * \param nSize     [I ] string size
 */
LIBALT_API void altStrncat (
  altChar *       pDst,
  const altUInt   nDstSize,
  const altChar * pSrc,
  const altUInt   nSize
);


/**
 * \brief format string
 *
 * \param pBuf      [IO] buffer
 * \param nBufSize  [I ] buffer size
 * \param szFormat  [I ] format
 * \param oArgs     [I ] arguments
 *
 * \return  string length
 */
LIBALT_API const altInt altVsnprintf (
  altChar *       pBuf,
  const altUInt   nBufSize,
  const altChar * szFormat,
  va_list &       oArgs
);


/**
 * \brief format string
 *
 * \param pBuf      [IO] buffer
 * \param nBufSize  [I ] buffer size
 * \param szFormat  [I ] format
 * \param oArgs     [I ] arguments
 *
 * \return  string length
 */
LIBALT_API const altInt altVswnprintf (
  altWChar *        pBuf,
  const altUInt     nBufSize,
  const wchar_t *   szFormat,
  va_list &         oArgs
);


/**
 * \brief sleep
 *
 * \param msec  [I ] sleep miliseconds
 */
LIBALT_API void altSleep (
  const DWORD msec
);


/**
 * \brief create directory
 *
 * \param szDirName  [I ] directory name
 *
 * \return true   success
 * \return false  error
 */
LIBALT_API const altBool altMkDir (
  const altChar * szDirName
);


/**
 * \brief create directory recursive
 *
 * \param szDirName  [I ] directory name
 *
 * \return true   success
 * \return false  error
 */
LIBALT_API const altBool altMkDirR (
  const altChar * szDirPath
);

///
/// \brief	open file
///
/// \param	pFile		    [ O] pointer of file stream
/// \param	szFileName	[I ] file name
/// \param	szMode		  [I ] open mode
///
void altFOpen (
  FILE * &        pFile,
  const altChar * szFileName,
  const altChar * szMode
);

///
/// \brief  Get wide string length
///
/// \param  szWStr  [I ] Wide string
///
/// \return Wide string length
///
altUInt altWStrLen (
  const altWChar *  szWStr
);


/**
 * \brief Copy wide string
 *
 * \param pDst  [ O] output
 * \param pSrc  [I ] source string
 * \param nSize [I ] string size
 */
LIBALT_API void altWStrncpy (
  altWChar *        pDst,
  const altWChar *  pSrc,
  const altUInt     nSize
);

#endif

