/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDBConnection.cpp 313 2007-09-03 10:43:12Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altDBConnection.cpp
 * \brief   DB Connection Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altDBConnection.h"

/*----------------------------------------------------------------*
 * Class variables
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
altDBConnection::altDBConnection()
{
}

///
/// \brief  Destructor
///
altDBConnection::~altDBConnection()
{
  alt_t status = ClearPreparedStatementCache();
  ALT_LOG (status);
}

///
/// \brief  Set Explain Log
///
/// \param  bEnable [I ] Enable or not
/// \param  sLogDir [I ] Explain Log Directory
///
/// \return ALT_S_SUCCESS   success
///
alt_t altDBConnection::SetExplainLog(altBool bEnable, const altStr & sLogDir)
{
  m_bExplainLogEnable = bEnable;
  m_bExplainLogDir = sLogDir;
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Clear Prepared Statement Cache
///
/// \return ALT_S_SUCCESS Success
///
alt_t altDBConnection::ClearPreparedStatementCache()
{
  for (altPreparedStatementMap::iterator i = m_oPreparedStatementMap.begin(); i != m_oPreparedStatementMap.end(); i++) {
    delete i->second;
    i->second = NULL;
  }
  m_oPreparedStatementMap.clear();
  ALT_RET (ALT_S_SUCCESS);
}


