/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDBConnectionPtr.cpp 327 2007-09-13 01:22:22Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altDBConnectionPtr.cpp
 * \brief   DB Connection Pointer Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altDBConnectionPtr.h"

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altDBConnectionPtr::altDBConnectionPtr() :
m_pDBConnection(NULL),
m_pDBManager(NULL)
{
}

///
/// \brief  Destructor
///
LIBALT_API altDBConnectionPtr::~altDBConnectionPtr()
{
  if (m_pDBManager != NULL) {
    alt_t status;
    status = m_pDBManager->ReleaseDBConnection (m_pDBConnection);
    ALT_LOG (status);
  }
}

///
/// \brief  Set Pointer
///
/// \param  pDBConnection   [I ] Pointer of DB Connection
/// \param  pDBManager      [I ] Pointer of DB Manager
///
/// \return ALT_S_SUCCESS   Success
///
LIBALT_API alt_t altDBConnectionPtr::Set(altDBConnection * pDBConnection, altDBManager * pDBManager)
{
  m_pDBConnection = pDBConnection;
  m_pDBManager = pDBManager;
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  operator ->
///
/// \return Pointer of DB Connection
///
LIBALT_API altDBConnection * altDBConnectionPtr::operator -> () const
{
  return (m_pDBConnection);
}
