/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDBResultSet.cpp 320 2007-09-04 11:49:50Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altDBResultSet.cpp
 * \brief   DB Result Set Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altDBResultSet.h"

/*----------------------------------------------------------------*
 * Class variables
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altDBResultSet::altDBResultSet()
{
}

///
/// \brief  Destructor
///
LIBALT_API altDBResultSet::~altDBResultSet()
{
}

///
/// \brief  Add Row
///
/// \param  oRow  [I ] Row Data
///
/// \return ALT_S_SUCCESS
///
LIBALT_API alt_t altDBResultSet::Add(const altDBRow & oRow)
{
  m_oResultData.push_back (oRow);
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Get Size
///
/// \return Row Count
///
LIBALT_API altUInt altDBResultSet::Size() const
{
  return ((altUInt)m_oResultData.size());
}

///
/// \brief  [] operator
///
/// \param  nIndex [I ] index
///
/// \return Row Data of index position
///
LIBALT_API const altDBRow & altDBResultSet::operator [](const altUInt nIndex) const ALT_THROWS (alt_t)
{
  if (nIndex >= Size()) {
    altStr sBuf;
    ALT_LOG_P (ALT_E_OUT_OF_INDEX, sBuf.Format ("[%u] >= [%u]", nIndex, Size()));
    throw (ALT_E_OUT_OF_INDEX);
  }
  return (m_oResultData[nIndex]);
}


