#ifndef ALTDBROW_H
#define ALTDBROW_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDBRow.h 212 2007-05-30 22:45:11Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altDBRow.h
 * \brief   DB Result Row Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altStr.h>
#include <altBase/altStatus.h>
#include <altBase/altLog.h>
#include <altBase/altBase.h>

#include <vector>
#include <map>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef std::vector<altChar *>      altRowContainer;  ///< Result Row Data Container
typedef std::map<altStr, altChar *> altRowMap;        ///< Result Row Data Map

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Result Record Row
///
class altDBRow : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  altDBRow();

  ///
  /// \brief  Destructor
  ///
  ~altDBRow();

  ///
  /// \brief  Add Column
  ///
  /// \param  sColumnName [I ] Column Name
  /// \param  pValue      [I ] Column Value
  /// \param  nValueSize  [I ] Column Value Size
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_NOMEM     out of memory
  ///
  alt_t Add(const altStr & sColumnName, altChar * pValue, const altUInt nValueSize);

  ///
  /// \brief  Get Size
  ///
  /// \return Row Count
  ///
  altUInt Size() const;

  ///
  /// \brief  [] operator
  ///
  /// \param  nIndex [I ] index
  ///
  /// \return Column Value
  ///
  LIBALT_API altChar * operator [](const altUInt nIndex) const ALT_THROWS (alt_t);

  ///
  /// \brief  [] operator
  ///
  /// \param  sColumnName [I ] Column Name
  ///
  /// \return Column Value
  ///
  LIBALT_API altChar * operator [](const altStr & sColumnName) const;

private:
  altRowContainer   m_oDataList;  ///< Result Data List
  mutable altRowMap m_oDataMap;   ///< Result Data Map
};

#endif //ALTDBROW_H

