#ifndef ALTPREPAREDSTATEMENT_H
#define ALTPREPAREDSTATEMENT_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altPreparedStatement.h 333 2007-10-01 05:08:18Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altPreparedStatement.h
 * \brief   Prepared Statement Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altBase.h>
#include <altDB/altSQL.h>
#include <altDB/altDBResultSet.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Prepared Statement
///
class altPreparedStatement : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  /// \param  oSQL  [I ] SQL
  ///
  LIBALT_API altPreparedStatement(const altSQL & oSQL);

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altPreparedStatement();

  ///
  /// \brief  Get SQL Name
  ///
  /// \return SQL Name
  ///
  LIBALT_API const altStr & GetSQLName() const;

  ///
  /// \brief  Execute
  ///
  /// \param  oResultSet  [ O] Result Set
  ///
  LIBALT_API virtual alt_t ExcecuteSQL(altDBResultSet & oResultSet) = 0;

  ///
  /// \brief  Execute
  ///
  /// \param  pCount      [ O] Affected Count
  ///
  LIBALT_API virtual alt_t ExcecuteSQL(altULongLong * pCount) = 0;

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API virtual alt_t Add(const altChar nVal, const altBool bIsNULL = false) = 0;

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API virtual alt_t Add(const altByte nVal, const altBool bIsNULL = false) = 0;

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API virtual alt_t Add(const altShort nVal, const altBool bIsNULL = false) = 0;

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API virtual alt_t Add(const altUShort nVal, const altBool bIsNULL = false) = 0;

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API virtual alt_t Add(const altInt nVal, const altBool bIsNULL = false) = 0;

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API virtual alt_t Add(const altUInt nVal, const altBool bIsNULL = false) = 0;

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API virtual alt_t Add(const altLong nVal, const altBool bIsNULL = false) = 0;

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API virtual alt_t Add(const altULong nVal, const altBool bIsNULL = false) = 0;

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API virtual alt_t Add(const altLongLong nVal, const altBool bIsNULL = false) = 0;

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API virtual alt_t Add(const altULongLong nVal, const altBool bIsNULL = false) = 0;

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API virtual alt_t Add(const altFloat nVal, const altBool bIsNULL = false) = 0;

  ///
  /// \brief  Add Value
  ///
  /// \param  nVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API virtual alt_t Add(const altDouble nVal, const altBool bIsNULL = false) = 0;

  ///
  /// \brief  Add Value
  ///
  /// \param  sVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API virtual alt_t Add(const altStr & sVal, const altBool bIsNULL = false) = 0;

  ///
  /// \brief  Add Value
  ///
  /// \param  oVal    [I ] Value
  /// \param  bIsNULL [I ] true...null false...not null
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_NOMEM   out of memory
  ///
  LIBALT_API virtual alt_t Add(const altDateTime & oVal, const altBool bIsNULL = false) = 0;

  ///
  /// \brief  Clear Value
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API virtual alt_t Clear() = 0;

  ///
  /// \brief  Get SQL String
  ///
  /// \return SQL String
  ///
  LIBALT_API virtual altStr toString() const = 0;

protected:
  altSQL    m_oSQL;   ///< SQL
};

#endif //ALTPREPAREDSTATEMENT_H
