/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSQLLoader.cpp 325 2007-09-12 10:49:24Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altSQLLoader.cpp
 * \brief   SQL Loader Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altSQLLoader.h"
#include "altMisc/altFile.h"
#include "altBase/altMem.h"

/*----------------------------------------------------------------*
 * Class variables
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altSQLLoader::altSQLLoader() :
m_oSQLContainer(),
m_sBaseDir()
{
}

///
/// \brief  Destructor
///
LIBALT_API altSQLLoader::~altSQLLoader()
{
  for (altSQLContainer::iterator i = m_oSQLContainer.begin(); i != m_oSQLContainer.end(); i++) {
    ALT_FREE (i->second);
  }
  m_oSQLContainer.clear();
}

///
/// \brief  Set Directory
///
/// \param  sDir  [I ] Directory Path
///
/// \return ALT_S_SUCCESS   Success
///
LIBALT_API alt_t altSQLLoader::SetDir(const altStr & sDir)
{
  m_sBaseDir = sDir;
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Get SQL
///
/// \param  sFilePath   [I ] File Path
/// \param  oSQL        [ O] SQL
///
/// \return ALT_S_SUCCESS   Success
/// \return ALT_E_ERROR     Error
///
LIBALT_API alt_t altSQLLoader::GetSQL(const altStr & sFilePath, altSQL & oSQL)
{
  altStr  sPath;
  altStr  sSQL;

  if (m_sBaseDir.GetLen() > 0) {
    sPath += m_sBaseDir;
    sPath += "/";
  }
  sPath += sFilePath;

  alt_t status;
  altChar * szSQL = m_oSQLContainer[sPath];
  if (szSQL != NULL) {
    status = oSQL.SetSQL (szSQL, sFilePath);
    ALT_ERR_RET (status);
    ALT_RET (ALT_S_SUCCESS);
  }

  altFile oFile;

  status = oFile.Open (sPath, "r");
  ALT_ERR_RET (status);

  altChar szBuf[BUFSIZ];
  while ((status = oFile.ReadLine (szBuf, sizeof (szBuf))) == ALT_S_SUCCESS) {
    // comment
    if (szBuf[0] == '#') {
      continue;
    }
    sSQL += szBuf;
  }

  status = oFile.Close();
  ALT_ERR_RET (status);

  status = ALT_STRALLOC (szSQL, sSQL.GetCStr());
  ALT_ERR_RET (status);
  m_oSQLContainer[sPath] = szSQL;

  status = oSQL.SetSQL (szSQL, sFilePath);
  ALT_ERR_RET (status);

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Get Prepared Statement SQL
///
/// \param  sFilePath     [I ] File Path
/// \param  oDBConnection [I ] DB Connection
/// \param  pStmt         [ O] Prepared Statement SQL
///
/// \return ALT_S_SUCCESS   Success
/// \return ALT_E_ERROR     Error
///
LIBALT_API alt_t altSQLLoader::GetSQL(const altStr & sFilePath, altDBConnection & oDBConnection, altPreparedStatement * & pStmt)
{
  alt_t   status;
  altSQL  oSQL;

  status = GetSQL (sFilePath, oSQL);
  ALT_ERR_RET (status);

  status = oDBConnection.GetPreparedStatement (oSQL, pStmt);
  ALT_ERR_RET (status);

  ALT_RET (ALT_S_SUCCESS);
}
