/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altEvent.cpp 729 2007-11-30 21:48:28Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altEvent.cpp
 * \brief   Event
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altEvent.h"
#ifdef ALT_WIN

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altEvent::altEvent(const altUInt nType, altComponent * pSource) :
m_nType (nType),
m_pSource (pSource)
{
}

///
/// \brief  Destructor
///
LIBALT_API altEvent::~altEvent()
{
}

///
/// \brief  Get event type
///
/// \return Event type
///
LIBALT_API altUInt altEvent::GetType() const
{
  return (m_nType);
}

///
/// \brief  Get event source
///
/// \return Evnet source
///
LIBALT_API altComponent * altEvent::GetEventSource() const
{
  return (m_pSource);
}

#endif
