/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altFontManager.cpp 778 2008-01-07 03:57:12Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altFontManager.cpp
 * \brief   DirectX 2D Font Manager
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altFontManager.h"
#ifdef ALT_WIN

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altFontManager::altFontManager() :
m_oFontMap()
{
  CreateFont ("Default", 12);
}

///
/// \brief  Destructor
///
LIBALT_API altFontManager::~altFontManager()
{
  for (altFontMap::iterator i = m_oFontMap.begin(); i != m_oFontMap.end(); i++) {
    delete i->second;
  }
  m_oFontMap.clear();
}

///
/// \brief  Create new font
///
/// \param  h         [I ] Font Height
/// \param  w         [I ] Font Width
/// \param  nWeight   [I ] Font weight
/// \param  bItalic   [I ] Italic or not
/// \param  nCharSet  [I ] Charcter set
/// \param  sFaceName [I ] Font face name
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
LIBALT_API alt_t altFontManager::CreateFont(const altStr & sFontName, const altInt h, const altInt w, const altUInt nWeight, const altBool bItalic, const BYTE nCharSet, const altWStr & sFaceName)
{
  try {
    altFont * pFont = ALT_NEW altFont (h, w, nWeight, bItalic, nCharSet, sFaceName);
    if (pFont == NULL) {
      ALT_RET (ALT_E_NOMEM);
    }
    m_oFontMap[sFontName] = pFont;
  }
  catch (alt_t e) {
    ALT_RET (e);
  }
  catch (std::exception & e) {
    ALT_LOG_P (ALT_E_ERROR, e.what());
    ALT_RET (ALT_E_ERROR);
  }
  catch (...) {
    ALT_RET (ALT_E_ERROR);
  }
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Get font
///
/// \param  sFontName [I ] Font name
///
/// \return Pointer of font
///
LIBALT_API altFont * altFontManager::GetFont(const altStr & sFontName)
{
  return (m_oFontMap[sFontName]);
}

///
/// \brief  Get altFontManager Instance
///
/// \return altDX Instance
///
LIBALT_API altFontManager & altFontManager::GetInstance()
{
  return (altSingleton<altFontManager>::GetInstance());
}

///
/// \brief  Delete Instance
///
LIBALT_API void altFontManager::DeleteInstance()
{
  altSingleton<altFontManager>::DeleteInstance();
}

#endif
