#ifndef ALTKEYEVENTLISTENER_H
#define ALTKEYEVENTLISTENER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altKeyEventListener.h 729 2007-11-30 21:48:28Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altKeyEventListener.h
 * \brief   Key Event Listener
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_WIN
#include <altDX/altEvent.h>
#include <altBase/altLog.h>

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Key Event Listener
///
class altKeyEventListener : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altKeyEventListener();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altKeyEventListener();

  ///
  /// \brief  Listen key down event
  ///
  /// \param  oEvent  [I ] Event
  /// \param  nKey    [I ] Key
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API virtual alt_t OnKeyDown(const altEvent & oEvent, const altUInt nKey) = 0;
};

#endif
#endif