/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altLight.cpp 748 2007-12-07 06:11:45Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altLight.cpp
 * \brief   Light
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altLight.h"
#ifdef ALT_WIN

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altLight::altLight() :
m_oLight()
{
}

///
/// \brief  Destructor
///
LIBALT_API altLight::~altLight()
{
}

///
/// \brief  Set light
///
/// \param  vecDirection  [I ] Direction
/// \param  oDiffuse      [I ] Diffuse Color
/// \param  oSpecular     [I ] Specular Color
/// \param  fRange        [I ] Range
///
/// \return ALT_S_SUCCESS success
///
LIBALT_API alt_t altLight::SetLight(const D3DXVECTOR3 & vecDirection, const D3DLIGHTTYPE nType, const D3DCOLORVALUE & oDiffuse, const D3DCOLORVALUE & oSpecular, const FLOAT fRange)
{
  ZeroMemory(& m_oLight, sizeof (m_oLight));
  m_oLight.Type = nType;
  m_oLight.Diffuse = oDiffuse;
  m_oLight.Specular = oSpecular;
  D3DXVec3Normalize ((D3DXVECTOR3 *)& m_oLight.Direction, & vecDirection);
  m_oLight.Range = fRange;
  aiDX.GetDevice()->SetLight (0, & m_oLight);
  aiDX.GetDevice()->LightEnable (0, TRUE);

  ALT_RET (ALT_S_SUCCESS);
}

#endif
