#ifndef ALTPROPERTY_H
#define ALTPROPERTY_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altProperty.h 135 2007-05-18 23:54:56Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altProperty.h
 * \brief   property
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altBaseLog.h>
#include <altBase/altStr.h>

#include <map>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef std::map<altStr, altStr *>  altPropertyData;  ///< setting data

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Property
///
class altProperty
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altProperty();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altProperty();

  ///
  /// \brief  Load Property File
  ///
  /// \param  sFileName [I ] file name
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t Load(const altStr & sFileName);

  ///
  /// \brief  Get Boolean Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  bDefault  [I ] Default Value
  ///
  /// \return Boolean Value
  ///
  LIBALT_API altBool GetBool(const altStr & sKey, const altBool nDefault = false);

  ///
  /// \brief  Get Short Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Short Value
  ///
  LIBALT_API altShort GetShort(const altStr & sKey, const altShort nDefault = 0);

  ///
  /// \brief  Get Unsigned Short Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Unsigned Short Value
  ///
  LIBALT_API altUShort GetUShort(const altStr & sKey, const altUShort nDefault = 0);

  ///
  /// \brief  Get Int Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Int Value
  ///
  LIBALT_API altInt GetInt(const altStr & sKey, const altInt nDefault = 0);

  ///
  /// \brief  Get Unsigned Int Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Unsigned Int Value
  ///
  LIBALT_API altUInt GetUInt(const altStr & sKey, const altUInt nDefault = 0);

  ///
  /// \brief  Get Long Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Long Value
  ///
  LIBALT_API altLong GetLong(const altStr & sKey, const altLong nDefault = 0);

  ///
  /// \brief  Get Unsigned Long Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Unsigned Long Value
  ///
  LIBALT_API altULong GetULong(const altStr & sKey, const altULong nDefault = 0);

  ///
  /// \brief  Get Long Long Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Long Long Value
  ///
  LIBALT_API altLongLong GetLongLong(const altStr & sKey, const altLongLong nDefault = 0);

  ///
  /// \brief  Get Unsigned Long Long Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Unsigned Long Long Value
  ///
  LIBALT_API altULongLong GetULongLong(const altStr & sKey, const altULongLong nDefault = 0);

  ///
  /// \brief  Get Float Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Float Value
  ///
  LIBALT_API altFloat GetFloat(const altStr & sKey, const altFloat nDefault = 0);

  ///
  /// \brief  Get Double Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  nDefault  [I ] Default Value
  ///
  /// \return Double Value
  ///
  LIBALT_API altDouble GetDouble(const altStr & sKey, const altDouble nDefault = 0);

  ///
  /// \brief  Get String Value
  ///
  /// \param  sKey      [I ] Key Name
  /// \param  sDefault  [I ] Default Value
  ///
  /// \return String Value
  ///
  LIBALT_API const altStr & GetStr(const altStr & sKey, const altStr & sDefault = "");

protected:
  altPropertyData   m_oPropertyDataMap;   ///< property data map
};

#endif  // ALTPROPERTY_H

