/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSHA1.cpp 471 2007-10-30 12:16:24Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altSHA1.cpp
 * \brief   SHA1
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altSHA1.h"

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altSHA1::altSHA1()
{
  memset (m_aHash, 0x00, sizeof (m_aHash));
}

///
/// \brief  Destructor
///
LIBALT_API altSHA1::~altSHA1()
{
}

///
/// \brief  Update SHA1 digest
///
/// \param  pData [I ] Data
/// \param  nSize [I ] Data size
///
/// \return ALT_S_SUCCESS   success
/// \return ALT_E_ERROR     error
///
LIBALT_API alt_t altSHA1::Update(const altUChar * pData, const altUInt nSize)
{
  if (pData == NULL) {
    ALT_RET (ALT_E_ERROR);
  }
  SHA1 (pData, nSize, m_aHash);
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  To string
///
/// \return string
///
LIBALT_API altStr altSHA1::ToStr()
{
  altStr  sRet;
  for (altUInt i = 0; i < ALT_ARRAY_SIZE (m_aHash); i++) {
    altStr  sTmp;
    sRet += sTmp.Format ("%02x", m_aHash[i]);
  }
  return (sRet);
}
