/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altClientPacket.cpp 718 2007-11-23 14:58:14Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altClientPacket.cpp
 * \brief   Client Packet Data Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altClientPacket.h"
#include "altBase/altMem.h"

/*----------------------------------------------------------------*
 * Class variables
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altClientPacket::altClientPacket() :
m_pData(),
m_nSize(0)
{
}

///
/// \brief  Destructor
///
LIBALT_API altClientPacket::~altClientPacket()
{
  m_nSize = 0;
}

///
/// \brief  Set Data
///
/// \param  pData           [I ] Data
/// \param  nSize           [I ] Data Size
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_NOMEM   out of memory
/// \return ALT_E_INVAL   invalid paramter
///
LIBALT_API alt_t altClientPacket::Set(const altCharPtr & pData, const altUInt nSize)
{
  m_pData = pData;
  m_nSize = nSize;

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Get Data
///
/// \return Data
///
LIBALT_API const altCharPtr altClientPacket::GetData() const
{
  return (m_pData);
}

///
/// \brief  Get Size
///
/// \return Size
///
LIBALT_API altUInt altClientPacket::GetSize() const
{
  return (m_nSize);
}

