/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNETConnection.cpp 672 2007-11-17 10:32:00Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altNETConnection.cpp
 * \brief   Network Connection
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altNETConnection.h"

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altNETConnection::altNETConnection(const SOCKADDR_IN & oSockAddrIn, const altInt nAcceptedPortNo, altNETSenderBroker & oSenderBroker) :
m_oSockAddrIn (oSockAddrIn),
m_nAcceptedPortNo (nAcceptedPortNo),
m_oSenderBroker (oSenderBroker),
m_bServerConnection (false)
{
}

///
/// \brief  Destructor
///
LIBALT_API altNETConnection::~altNETConnection()
{
}

///
/// \brief Get IP Address
///
/// \return IP Address
///
LIBALT_API const altStr altNETConnection::GetIP() const
{
  return m_oSockAddrIn.GetIP();
}

///
/// \brief Get Port NO
///
/// \return Port NO
///
LIBALT_API altInt altNETConnection::GetPort() const
{
  return m_oSockAddrIn.GetPort();
}

///
/// \brief  Get accepted port number
///
/// \return Accepted port number
///
LIBALT_API const altInt altNETConnection::GetAcceptedPort() const
{
  return (m_nAcceptedPortNo);
}

///
/// \brief  Send Data
///
/// \param  pData [I ] send data
/// \param  nSize [I ] send data size
///
/// \return ALT_S_SUCCESS   successs
/// \return ALT_E_NOMEM     out of memory
/// \return ALT_E_ERROR     error
///
LIBALT_API alt_t altNETConnection::Send(const altCharPtr & pData, const altInt nSize) const
{
  if (pData == NULL || nSize == 0) {
    ALT_RET (ALT_S_SUCCESS);
  }

  alt_t status = m_oSenderBroker.Send (this, pData, nSize);
  ALT_ERR_RET (status);

  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Get server connection or not
///
/// \return true  server connection
/// \return false client connection
///
LIBALT_API altBool altNETConnection::IsServerConnection() const
{
  return (m_bServerConnection);
}
