/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNETPacket.cpp 631 2007-11-16 07:19:48Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altNETPacket.cpp
 * \brief   Network Packet Data Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altNETPacket.h"
#include "altBase/altMem.h"
/*----------------------------------------------------------------*
 * Class variables
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altNETPacket::altNETPacket() :
m_pData (),
m_nSize (0),
m_pConnection (NULL)
{
}

///
/// \brief  Destructor
///
LIBALT_API altNETPacket::~altNETPacket()
{
  m_nSize = 0;
  m_pConnection = NULL;
}

///
/// \brief  Set Data
///
/// \param  pNETConnection  [I ] NET Connection
/// \param  pData           [I ] network data
/// \param  nSize           [I ] data size
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_NOMEM   out of memory
/// \return ALT_E_INVAL   invalid paramter
///
LIBALT_API alt_t altNETPacket::Set(const altCNETConnectionPtr & pNETConnection, const altCharPtr & pData, const altUInt nSize)
{
  ALT_P_ASSERT (pData != NULL);
  m_pData = pData;
  m_nSize = nSize;
  m_pConnection = pNETConnection;
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Get Data
///
/// \param  pNETConnection  [ O] NET Connection
/// \param  pData           [ O] network data
/// \param  nSize           [ O] data size
///
/// \return ALT_S_SUCCESS success
///
LIBALT_API alt_t altNETPacket::Get(altCNETConnectionPtr & pNETConnection, altCharPtr & pData, altUInt & nSize)
{
  pData = m_pData;
  nSize = m_nSize;
  pNETConnection = m_pConnection;

  ALT_RET (ALT_S_SUCCESS);
}
