#ifndef ALTNETRECEIVERBROKER_H
#define ALTNETRECEIVERBROKER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNETReceiverBroker.h 796 2008-01-21 08:19:28Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altNETReceiverBroker.h
 * \brief   NET Recevier Broker
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNet/altNETReceiver.h>
#include <altNet/altNETConnection.h>
#include <altBase/altPtr.h>
#include <altBase/altUncopyable.h>
#include <altBase/altSyncThread.h>
#include <altBase/altLoopThread.h>

#include <vector>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef std::vector<altNETReceiver *>  altNETReceiverContainer; ///< NET Receiver Container

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  NET Connection Class
///
class altNETReceiverBroker : public altBase, private altUncopyable, private altSyncThread
{
public:
  ///
  /// \brief  Constructor
  ///
  /// \param  pReceiveCallBack      [I ] NET Data Receive Call Back Function
  /// \param  nThreadCount          [I ] Request Thread Count
  ///
  LIBALT_API altNETReceiverBroker(const altNETReceiveCallBack pCallBackFunc, const altUInt nThreadCount = 10);

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altNETReceiverBroker();

  ///
  /// \brief  Add NET Connection
  ///
  /// \param  pNETConnection  [I ] NET Connection
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t Add(const altCNETConnectionPtr & pNETConnection);

  ///
  /// \brief  Delete NET Connection
  ///
  /// \param  pNETConnection  [I ] NET Connection
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t Del(const altCNETConnectionPtr & pNETConnection);

  ///
  /// \brief  Delete all client connection
  ///
  LIBALT_API void DelAllClient();

  ///
  /// \brief  Set receive buffer size
  ///
  /// \param  nSize [I ] receive buffer size
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_INVAL     invalid paramter
  ///
  LIBALT_API alt_t SetRecvBufferSize(const altUInt nSize);

protected:
  ///
  /// \brief  New NET Receiver
  ///
  LIBALT_API void CreateNewNETReceiver();

  ///
  /// \brief  Deleter Thread
  ///
  /// \param  pParam  [IO] this object
  ///
  LIBALT_API static alt_t DeleterThread(void * pParam);

  altNETReceiverContainer    m_oNETReceiverContainer;  ///< NET Receiver Container
  altNETReceiveCallBack      m_pReceiveCallBackFunc;   ///< NET Receive Call Back Function
  altUInt                    m_nRequestThreadCount;    ///< Request Thread Count
  altLoopThread              m_oDeleterThread;         ///< Deleter Thread
};
#endif  //ALTNETRECEIVERBROKER_H
