/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNETServerConnection.cpp 669 2007-11-17 07:38:38Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altNETServerConnection.cpp
 * \brief   Server Network Connection
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altNETServerConnection.h"

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altNETServerConnection::altNETServerConnection(const altNETServerInfo & oServerInfo) :
m_oServerInfo (oServerInfo)
{
}

///
/// \brief  Destructor
///
LIBALT_API altNETServerConnection::~altNETServerConnection()
{
}

///
/// \brief  Call accept call back function
///
/// \param  nPort           [I ] Accepted port number
/// \param  pNETConnection  [I ] Pointer of server connection
///
void altNETServerConnection::CallAcceptCallBack(const altInt nPort) const
{
  m_oServerInfo.CallAcceptCallBack (nPort, this);
}

///
/// \brief  Call receive call back function
///
/// \param  pConnection [I ] Pointer of server connection
/// \param  pData       [I ] Receive data
/// \param  nSize       [I ] Receive data size
///
/// \return ALT_S_SUCCESS success
/// \return ALT_E_ERROR   error
///
alt_t altNETServerConnection::CallReceiveCallBack(const altCharPtr & pData, const altUInt nSize) const
{
  alt_t status;
  status = m_oServerInfo.CallReceiveCallBack (this, pData, nSize);
  ALT_ERR_RET (status);
  ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief  Call disconnect call back function
///
/// \param  pConnection [I ] Pointer of server connection
///
void altNETServerConnection::CallDisconnectCallBack() const
{
  m_oServerInfo.CallDisconnectCallBack (this);
}
