/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSSLServerConnection.cpp 673 2007-11-17 10:35:22Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altTCPServerConnection.cpp
 * \brief   TCP Server Network Connection
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altSSLServerConnection.h"

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
/// \param  pSSL            [I ] Pointer of SSL Object
/// \param  m_pSSLContext   [I ] Pointer of SSL Context Object
/// \param  nSocket         [I ] Socket
/// \param  oSockAddrIn     [I ] Internet socket address
/// \param  nAcceptedPortNo [I ] Accepted port number
/// \param  oSenderBroker   [I ] Sender broker
/// \param  oServerInfo     [I ] Server infomation
///
LIBALT_API altSSLServerConnection::altSSLServerConnection(SSL * pSSL, SSL_CTX * pSSLContext, const SOCKET nSocket, const SOCKADDR_IN & oSockAddrIn, const altInt nAcceptedPortNo, altNETSenderBroker & oSenderBroker, const altNETServerInfo & oServerInfo) :
altSSLConnection (pSSL, pSSLContext, nSocket, oSockAddrIn, nAcceptedPortNo, oSenderBroker),
altNETServerConnection (oServerInfo)
{
  m_bServerConnection = true;
}

///
/// \brief  Destructor
///
LIBALT_API altSSLServerConnection::~altSSLServerConnection()
{
}
