/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSSLSyncThread.cpp 664 2007-11-16 22:29:26Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altSSLSyncThread.cpp
 * \brief   SSL Synchronize Thread Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altSSLSyncThread.h"
#include "openssl/ssl.h"
#include "altBase/altLog.h"

/*----------------------------------------------------------------*
 * Static variables
 *----------------------------------------------------------------*/
altBool                 altSSLSyncThread::bInitDone = false;   ///< tO
altSyncThreadContainer  altSSLSyncThread::oSyncThreads;        ///< IuWFNg̓ꕨ

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief Constructor
///
altSSLSyncThread::altSSLSyncThread()
{
}

///
/// \brief Destructor
///
altSSLSyncThread::~altSSLSyncThread()
{
  alt_t status = End();
  ALT_LOG (status);
}

///
/// \brief	Initialize
///
/// \return ALT_S_SUCCESS   success
/// \return ALT_E_ERROR     error
///
alt_t altSSLSyncThread::InitLock()
{
	if (! bInitDone) {
		for (altInt i = 0; i < CRYPTO_num_locks(); i++) {
      try {
			  altSyncThread * pSyncThread = new altSyncThread ();
        oSyncThreads.push_back (pSyncThread);
      }
      catch (std::exception & e) {
        ALT_RET_P (ALT_E_ERROR, e.what());
      }
      catch (...) {
        ALT_RET (ALT_E_ERROR);
      }
		}
		CRYPTO_set_locking_callback (LockingCallback);
		bInitDone =  true;
	}
	ALT_RET (ALT_S_SUCCESS);
}

///
/// \brief	Lock Call Back Function
///
void altSSLSyncThread::LockingCallback(altInt nMode, altInt nType, const altChar * pFile, altInt nLine)
{
	if (nMode & CRYPTO_LOCK) {
		oSyncThreads[nType]->BeginLock ();
	}
	else {
		oSyncThreads[nType]->EndLock ();
	}
}

///
/// \brief	end of using
///
/// \return ALT_S_SUCCESS	  Success
///
alt_t altSSLSyncThread::End()
{
	for (altSyncThreadContainer::iterator i = oSyncThreads.begin (); i != oSyncThreads.end (); i++) {
		delete (* i);
		(* i) = NULL;
	}
	oSyncThreads.clear ();
	ALT_RET (ALT_S_SUCCESS);
}

