/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSocketAddress.cpp 139 2007-05-20 05:42:30Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altSocketAddress.cpp
 * \brief   Socket Address
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include "altSocketAddress.h"

/*----------------------------------------------------------------*
 * Class variables
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Function Implements
 *----------------------------------------------------------------*/
///
/// \brief  Constructor
///
LIBALT_API altSocketAddress::altSocketAddress()
{
  memset (& m_oAddr, 0x00, sizeof (m_oAddr));
  m_nAddrLen = sizeof (m_oAddr);
}

///
/// \brief  Constructor
///
/// \param  oAddr     [I ] Socket Address
/// \param  nAddrLen  [I ] Socket Address Length
///
LIBALT_API altSocketAddress::altSocketAddress(const SOCKADDR & oAddr, const altUInt nAddrLen) :
m_oAddr (oAddr),
m_nAddrLen (nAddrLen)
{
}

///
/// \brief  Destructor
///
LIBALT_API altSocketAddress::~altSocketAddress()
{
}

///
/// \brief  Get Socket Address
///
/// \return Socket Address
///
LIBALT_API const SOCKADDR & altSocketAddress::GetAddr() const
{
  return m_oAddr;
}

///
/// \brief  Get Socket Address Length
///
/// \return Socket Address Length
///
LIBALT_API altUInt altSocketAddress::GetAddrLen() const
{
  return m_nAddrLen;
}

///
/// \brief  Get Pointer of Socket Address
///
/// \return Pointer of Socket Address
///
LIBALT_API const SOCKADDR * altSocketAddress::GetAddrPtr() const
{
  return & m_oAddr;
}
