#ifndef ALTTCPSERVERCONNECTION_H
#define ALTTCPSERVERCONNECTION_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altTCPServerConnection.h 671 2007-11-17 08:05:04Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altTCPServerConnection.h
 * \brief   TCP Server Network Connection
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNet/altNETServerInfo.h>
#include <altNet/altNETServerConnection.h>
#include <altNet/altTCPConnection.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Server Network Connection Class
///
class altTCPServerConnection : public altTCPConnection, public altNETServerConnection
{
public:
  ///
  /// \brief  Constructor
  ///
  /// \param  nSocket         [I ] Socket
  /// \param  oSockAddrIn     [I ] Internet socket address
  /// \param  nAcceptedPortNo [I ] Accepted port number
  /// \param  oSenderBroker   [I ] Sender broker
  /// \param  oServerInfo     [I ] Server infomation
  ///
  LIBALT_API altTCPServerConnection(const SOCKET nSocket, const SOCKADDR_IN & oSockAddrIn, const altInt nAcceptedPortNo, altNETSenderBroker & oSenderBroker, const altNETServerInfo & oServerInfo);

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altTCPServerConnection();

private:
  altNETServerInfo  m_oServerInfo;
};

#endif
