/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.ICustomTagAttributeAssist;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.JSFProject;
import tk.eclipse.plugin.jsf.JSFTagDefinition;
import tk.eclipse.plugin.jsf.ManagedBean;
import tk.eclipse.plugin.jsf.ManagedBeanProperty;
import tk.eclipse.plugin.jsf.Util;

public class JSFAttributeAssist
implements ICustomTagAttributeAssist {
    private Image classImage = JSFPlugin.getDefault().getImageRegistry().get("__icon_class");
    private Image fieldImage = JSFPlugin.getDefault().getImageRegistry().get("__icon_field");
    private Image methodImage = JSFPlugin.getDefault().getImageRegistry().get("__icon_method");

    public AssistInfo[] getAttributeValues(String tagName, String uri, String value, AttributeInfo attrInfo) {
        try {
            if (!(uri.equals("http://java.sun.com/jsf/html") || uri.equals("http://java.sun.com/jsf/core") || uri.equals("http://myfaces.sourceforge.net/tld/myfaces_ext_0_9.tld"))) {
                return null;
            }
            if (!this.getFile().getProject().hasNature("tk.eclipse.plugin.jsf.JSFProjectNature")) {
                return null;
            }
            String attrName = attrInfo.getAttributeName();
            if (value.startsWith("#{")) {
                value = value.replaceFirst("^#\\{", "");
                if ((value = value.replaceFirst("\\}$", "")).indexOf(".") == -1) {
                    ManagedBean[] beans = this.getProject().getManagedBeans();
                    AssistInfo[] assists = new AssistInfo[beans.length];
                    int i = 0;
                    while (i < assists.length) {
                        assists[i] = new AssistInfo("#{" + beans[i].getBeanName(), String.valueOf(beans[i].getBeanName()) + " - " + beans[i].getClassName(), this.classImage);
                        ++i;
                    }
                    return assists;
                }
                String type = JSFTagDefinition.getAttributeInfo(tagName, attrName);
                String[] dim = value.split("\\.");
                String[] props = null;
                String name = null;
                ManagedBean[] beans = this.getProject().getManagedBeans();
                int i = 0;
                while (i < beans.length) {
                    if (beans[i].getBeanName().equalsIgnoreCase(dim[0])) {
                        name = beans[i].getBeanName();
                        if (type == "prop") {
                            ManagedBeanProperty[] beanProps = beans[i].getProperties();
                            AssistInfo[] info = new AssistInfo[beanProps.length];
                            int j = 0;
                            while (j < beanProps.length) {
                                info[j] = new AssistInfo("#{" + name + "." + beanProps[j].getPropertyName(), String.valueOf(beanProps[j].getPropertyName()) + " - " + beanProps[j].getPropertyType(), this.fieldImage);
                                ++j;
                            }
                            return info;
                        }
                        if (type == "action") {
                            props = beans[i].getActionMethodNames();
                        } else if (type == "actionListener") {
                            props = beans[i].getActionListenerMethodNames();
                        } else if (type == "valudaChangeListener") {
                            props = beans[i].getValueChangeListenerMethodNames();
                        } else if (type == "validater") {
                            props = beans[i].getValidaterMethodNames();
                        }
                    }
                    ++i;
                }
                if (props != null) {
                    AssistInfo[] assists = new AssistInfo[props.length];
                    int i2 = 0;
                    while (i2 < assists.length) {
                        assists[i2] = new AssistInfo("#{" + name + "." + props[i2], props[i2], this.methodImage);
                        ++i2;
                    }
                    return assists;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private JSFProject getProject() {
        IProject project = this.getFile().getProject();
        return new JSFProject(JavaCore.create((IProject)project));
    }

    private IFile getFile() {
        IEditorPart editor = Util.getActiveEditor();
        return ((IFileEditorInput)editor.getEditorInput()).getFile();
    }
}

