/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.wizards;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.Util;
import tk.eclipse.plugin.jsf.wizards.JSFSupportWizardPage;

public class JSFSupportWizard
extends Wizard
implements INewWizard {
    private JSFSupportWizardPage page;
    private IStructuredSelection selection;
    private ResourceBundle resource = JSFPlugin.getDefault().getResourceBundle();
    public static final String[] JARS = new String[]{"/myfaces-1.0.8/lib/commons-beanutils-1.6.1.jar", "/myfaces-1.0.8/lib/commons-codec-1.2.jar", "/myfaces-1.0.8/lib/commons-collections-3.0.jar", "/myfaces-1.0.8/lib/commons-digester-1.5.jar", "/myfaces-1.0.8/lib/commons-el.jar", "/myfaces-1.0.8/lib/commons-fileupload-1.0.jar", "/myfaces-1.0.8/lib/commons-logging.jar", "/myfaces-1.0.8/lib/commons-validator.jar", "/myfaces-1.0.8/lib/jakarta-oro.jar", "/myfaces-1.0.8/lib/jstl.jar", "/myfaces-1.0.8/lib/myfaces.jar"};

    public JSFSupportWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        final String projectName = this.page.getWebAppRoot();
        final boolean addJARs = this.page.getAddStrutsLibraries();
        final boolean createStrutsConfigXML = this.page.getCreateFacesConfigXML();
        final boolean createWebXML = this.page.getCreateWebXML();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        JSFSupportWizard.this.doFinish(projectName, addJARs, createStrutsConfigXML, createWebXML, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            Util.openErrorDialog(realException);
            return false;
        }
        return true;
    }

    private void doFinish(String path, boolean addJARs, boolean createFacesConfigXML, boolean createWebXML, IProgressMonitor monitor) throws CoreException {
        File libdir;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(path));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            Util.throwCoreException(Util.createMessage(this.resource.getString("error.notexists"), new String[]{path}));
        }
        this.addNature(resource.getProject(), path);
        int totalTask = 0;
        if (addJARs) {
            totalTask += JARS.length;
        }
        if (createFacesConfigXML) {
            ++totalTask;
        }
        if (createWebXML) {
            ++totalTask;
        }
        monitor.beginTask(JSFPlugin.getResourceString("wizard.jsfSupport.title"), totalTask);
        int task = 1;
        IContainer container = (IContainer)resource;
        File webinf = container.getFolder((IPath)new Path("/WEB-INF")).getLocation().makeAbsolute().toFile();
        if (!webinf.exists()) {
            webinf.mkdir();
        }
        if (!(libdir = container.getFolder((IPath)new Path("/WEB-INF/lib")).getLocation().makeAbsolute().toFile()).exists()) {
            libdir.mkdir();
        }
        if (addJARs) {
            int i = 0;
            while (i < JARS.length) {
                this.copyFile(monitor, container, JARS[i], "/WEB-INF/lib");
                monitor.worked(task);
                ++task;
                ++i;
            }
            container.refreshLocal(2, monitor);
            IJavaProject project = JavaCore.create((IProject)container.getProject());
            IClasspathEntry[] rawClasspath = project.getRawClasspath();
            ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
            list.addAll(Arrays.asList(rawClasspath));
            int i2 = 0;
            while (i2 < JARS.length) {
                String fileName = new File(JARS[i2]).getName();
                IClasspathEntry classPath = JavaCore.newLibraryEntry((IPath)new Path(String.valueOf(path) + "/WEB-INF/lib/" + fileName), null, null);
                if (!list.contains(classPath)) {
                    list.add(classPath);
                }
                ++i2;
            }
            IClasspathEntry[] newClasspath = list.toArray(new IClasspathEntry[list.size()]);
            project.setRawClasspath(newClasspath, monitor);
        }
        if (createFacesConfigXML) {
            monitor.beginTask(JSFPlugin.getResourceString("wizard.progress.createFacesConfigXML"), 1);
            try {
                IFile file = container.getFile((IPath)new Path("/WEB-INF/faces-config.xml"));
                InputStream stream = this.createFacesConfigStream();
                if (file.exists()) {
                    file.setContents(stream, true, true, monitor);
                } else {
                    file.create(stream, true, monitor);
                }
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            monitor.worked(task++);
        }
        if (createWebXML) {
            monitor.beginTask(JSFPlugin.getResourceString("wizard.progress.createWebXML"), 1);
            this.copyFile(monitor, container, "/myfaces-1.0.8/conf/web.xml", "/WEB-INF");
            monitor.worked(task++);
        }
        container.refreshLocal(2, monitor);
    }

    private void addNature(IProject project, String path) throws CoreException {
        HTMLProjectParams params = new HTMLProjectParams();
        params.setRoot("/" + new Path(path).removeFirstSegments(1).toString());
        params.save(project);
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if (natures[i].equals("tk.eclipse.plugin.jsf.JSFProjectNature")) {
                return;
            }
            ++i;
        }
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "tk.eclipse.plugin.jsf.JSFProjectNature";
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }

    private synchronized void copyFile(IProgressMonitor monitor, IContainer container, String entry, String target) {
        try {
            URL url = JSFPlugin.getDefault().getBundle().getEntry(entry);
            String fileName = new File(entry).getName();
            File file = container.getFile((IPath)new Path(String.valueOf(target) + "/" + fileName)).getLocation().makeAbsolute().toFile();
            InputStream in = url.openStream();
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[8192];
            int length = 0;
            while ((length = in.read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, length);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception ex) {
            Util.openErrorDialog(ex);
        }
    }

    private InputStream createFacesConfigStream() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\"?>\n");
        sb.append("<!DOCTYPE faces-config PUBLIC ");
        sb.append("\"-//Sun Microsystems, Inc.//DTD JavaServer Faces Config 1.1//EN\" ");
        sb.append("\"http://java.sun.com/dtd/web-facesconfig_1_1.dtd\">\n");
        sb.append("<faces-config>\n");
        sb.append("</faces-config>\n");
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        this.page = new JSFSupportWizardPage((ISelection)this.selection);
        this.addPage((IWizardPage)this.page);
    }
}

