/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.assist;

import com.steadystate.css.parser.CSSOMParser;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.eclipse.core.resources.IFile;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;

public class CSSAssistProcessor {
    private HashMap rules = new HashMap();
    private IFile file;

    public void reload(IFile file, String source) {
        this.file = file;
        this.rules.clear();
        source = HTMLUtil.scriptlet2space(source, false);
        FuzzyXMLDocument doc = new FuzzyXMLParser().parse(source);
        if (doc != null) {
            this.processElement(doc.getDocumentElement());
        }
    }

    private void processElement(FuzzyXMLElement element) {
        if (element.getName().equalsIgnoreCase("link")) {
            String rel = "";
            String type = "";
            String href = "";
            FuzzyXMLAttribute[] attrs = element.getAttributes();
            int i = 0;
            while (i < attrs.length) {
                if (attrs[i].getName().equalsIgnoreCase("rel")) {
                    rel = attrs[i].getValue();
                } else if (attrs[i].getName().equalsIgnoreCase("type")) {
                    type = attrs[i].getValue();
                } else if (attrs[i].getName().equalsIgnoreCase("href")) {
                    href = attrs[i].getValue();
                }
                ++i;
            }
            if (rel.equalsIgnoreCase("stylesheet") && type.equalsIgnoreCase("text/css")) {
                try {
                    IFile css = this.getFile(href);
                    if (css != null && css.exists()) {
                        String text = new String(HTMLUtil.readStream(css.getContents()));
                        this.processStylesheet(text);
                    }
                }
                catch (Exception ex) {}
            }
        } else if (element.getName().equalsIgnoreCase("style")) {
            String type = "";
            FuzzyXMLAttribute[] attrs = element.getAttributes();
            int i = 0;
            while (i < attrs.length) {
                if (attrs[i].getName().equalsIgnoreCase("type")) {
                    type = attrs[i].getValue();
                }
                ++i;
            }
            if (type.equalsIgnoreCase("text/css")) {
                String text = HTMLUtil.getXPathValue(element, "/");
                this.processStylesheet(text);
            }
        }
        FuzzyXMLNode[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof FuzzyXMLElement) {
                this.processElement((FuzzyXMLElement)children[i]);
            }
            ++i;
        }
    }

    private IFile getFile(String path) {
        if (path.startsWith("/")) {
            return null;
        }
        return this.file.getProject().getFile(this.file.getParent().getProjectRelativePath().append(path));
    }

    private void processStylesheet(String css) {
        try {
            CSSOMParser parser = new CSSOMParser();
            InputSource is = new InputSource((Reader)new StringReader(css));
            CSSStyleSheet stylesheet = parser.parseStyleSheet(is);
            CSSRuleList list = stylesheet.getCssRules();
            int i = 0;
            while (i < list.getLength()) {
                CSSRule rule = list.item(i);
                if (rule instanceof CSSStyleRule) {
                    CSSStyleRule styleRule = (CSSStyleRule)rule;
                    String selector = styleRule.getSelectorText();
                    SelectorList selectors = parser.parseSelectors(new InputSource((Reader)new StringReader(selector)));
                    int j = 0;
                    while (j < selectors.getLength()) {
                        Selector sel = selectors.item(j);
                        if (sel instanceof ConditionalSelector) {
                            Condition cond = ((ConditionalSelector)sel).getCondition();
                            SimpleSelector simple = ((ConditionalSelector)sel).getSimpleSelector();
                            if (simple instanceof ElementSelector) {
                                String tagName = ((ElementSelector)simple).getLocalName();
                                tagName = tagName == null ? "*" : tagName.toLowerCase();
                                if (cond instanceof AttributeCondition) {
                                    ArrayList classes;
                                    AttributeCondition attrCond = (AttributeCondition)cond;
                                    if (this.rules.get(tagName) == null) {
                                        classes = new ArrayList();
                                        classes.add(attrCond.getValue());
                                        this.rules.put(tagName, classes);
                                    } else {
                                        classes = (ArrayList)this.rules.get(tagName);
                                        classes.add(attrCond.getValue());
                                    }
                                }
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public AssistInfo[] getAssistInfo(String tagName, String value) {
        try {
            value = value.indexOf(32) != -1 ? value.substring(0, value.lastIndexOf(32) + 1) : "";
            ArrayList assists = new ArrayList();
            ArrayList all = (ArrayList)this.rules.get("*");
            if (all != null) {
                assists.addAll(all);
            }
            if (this.rules.get(tagName.toLowerCase()) != null) {
                ArrayList list = (ArrayList)this.rules.get(tagName.toLowerCase());
                assists.addAll(list);
            }
            AssistInfo[] info = new AssistInfo[assists.size()];
            int i = 0;
            while (i < assists.size()) {
                String keyword = (String)assists.get(i);
                info[i] = new AssistInfo(String.valueOf(value) + keyword, keyword);
                ++i;
            }
            return info;
        }
        catch (Exception exception) {
            return new AssistInfo[0];
        }
    }
}

