/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.views;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.eclipse.gef.Tool;
import org.eclipse.gef.internal.ui.palette.editparts.ToolEntryEditPart;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.TagInfo;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.views.DefaultPaletteItem;
import tk.eclipse.plugin.htmleditor.views.IPaletteContributer;
import tk.eclipse.plugin.htmleditor.views.IPaletteItem;
import tk.eclipse.plugin.htmleditor.views.IPaletteTarget;
import tk.eclipse.plugin.jspeditor.editors.TLDResolver;
import tk.eclipse.plugin.jspeditor.editors.TLDSAXHandler;

public class PaletteView
extends ViewPart {
    private PaletteViewer viewer;
    private TreeMap items = new TreeMap();
    private HashMap tools = new HashMap();
    private String[] defaultCategories;

    public PaletteView() {
        this.addPaletteItem("HTML", new DefaultPaletteItem("form", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_form"), "<form action=\"\" method=\"\"></form>"));
        this.addPaletteItem("HTML", new DefaultPaletteItem("text", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_text"), "<input type=\"text\" name=\"\" value=\"\" />"));
        this.addPaletteItem("HTML", new DefaultPaletteItem("textarea", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_textarea"), "<textarea name=\"\" rows=\"\" cols=\"\"></textarea>"));
        this.addPaletteItem("HTML", new DefaultPaletteItem("password", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_pass"), "<input type=\"password\" name=\"\" value=\"\" />"));
        this.addPaletteItem("HTML", new DefaultPaletteItem("radio", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_radio"), "<input type=\"radio\" name=\"\" value=\"\" />"));
        this.addPaletteItem("HTML", new DefaultPaletteItem("checkbox", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_check"), "<input type=\"checkbox\" name=\"\" value=\"\" />"));
        this.addPaletteItem("HTML", new DefaultPaletteItem("button", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_button"), "<input type=\"button\" name=\"\" value=\"\" />"));
        this.addPaletteItem("HTML", new DefaultPaletteItem("submit", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_button"), "<input type=\"submit\" name=\"\" value=\"\" />"));
        this.addPaletteItem("HTML", new DefaultPaletteItem("reset", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_button"), "<input type=\"reset\" value=\"\" />"));
        this.addPaletteItem("JSP", new DefaultPaletteItem("jsp:useBean", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_tag"), "<jsp:useBean id=\"\" class=\"\" scope=\"\" />"));
        this.addPaletteItem("JSP", new DefaultPaletteItem("jsp:include", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_tag"), "<jsp:include />"));
        this.addPaletteItem("JSP", new DefaultPaletteItem("jsp:forward", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_tag"), "<jsp:forward />"));
        String[] groups = HTMLPlugin.getDefault().getPaletteContributerGroups();
        int i = 0;
        while (i < groups.length) {
            IPaletteContributer contributer = HTMLPlugin.getDefault().getPaletteContributer(groups[i]);
            IPaletteItem[] items = contributer.getPaletteItems();
            int j = 0;
            while (j < items.length) {
                this.addPaletteItem(groups[i], items[j]);
                ++j;
            }
            ++i;
        }
        this.defaultCategories = this.getCategories();
    }

    private void createToolBar() {
        Action customize = new Action("Configuration", HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_property")){

            public void run() {
                PaletteCustomizeDialog dialog = new PaletteCustomizeDialog(PaletteView.this.getViewSite().getShell());
                dialog.open();
            }
        };
        customize.setToolTipText("Configuration");
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)customize);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new PaletteViewer();
        this.viewer.createControl(parent);
        PaletteRoot root = new PaletteRoot();
        String[] category = this.getCategories();
        int i = 0;
        while (i < category.length) {
            PaletteDrawer group = new PaletteDrawer(category[i]);
            IPaletteItem[] items = this.getPaletteItems(category[i]);
            int j = 0;
            while (j < items.length) {
                HTMLPaletteEntry entry = new HTMLPaletteEntry(items[j].getLabel(), null, items[j].getImageDescriptor());
                this.tools.put(entry, items[j]);
                group.add((PaletteEntry)entry);
                ++j;
            }
            root.add((PaletteEntry)group);
            ++i;
        }
        this.viewer.setPaletteRoot(root);
        this.viewer.addPaletteListener(new PaletteListener(){

            public void activeToolChanged(PaletteViewer palette, ToolEntry tool) {
                ToolEntryEditPart part = (ToolEntryEditPart)palette.getEditPartRegistry().get(tool);
                if (part != null) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorPart editorPart = page.getActiveEditor();
                    if (editorPart != null) {
                        if (editorPart instanceof HTMLSourceEditor) {
                            IPaletteItem item = (IPaletteItem)PaletteView.this.tools.get(tool);
                            item.execute((HTMLSourceEditor)editorPart);
                        } else if (editorPart instanceof IPaletteTarget) {
                            IPaletteItem item = (IPaletteItem)PaletteView.this.tools.get(tool);
                            item.execute(((IPaletteTarget)editorPart).getPaletteTarget());
                        }
                    }
                    part.setToolSelected(false);
                }
            }
        });
        this.viewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editorPart = page.getActiveEditor();
                if (editorPart != null) {
                    editorPart.setFocus();
                }
            }
        });
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        String xml = store.getString("_pref_palette_items");
        if (xml != null) {
            FuzzyXMLDocument doc = new FuzzyXMLParser().parse(xml);
            FuzzyXMLNode[] groups = HTMLUtil.selectXPathNodes(doc.getDocumentElement(), "/palette/groups/group");
            int i2 = 0;
            while (i2 < groups.length) {
                FuzzyXMLElement group = (FuzzyXMLElement)groups[i2];
                String name = group.getAttributeNode("name").getValue();
                boolean visible = new Boolean(group.getAttributeNode("visible").getValue());
                List entries = this.viewer.getPaletteRoot().getChildren();
                PaletteDrawer drawer = null;
                int j = 0;
                while (j < entries.size()) {
                    drawer = (PaletteDrawer)entries.get(j);
                    if (drawer.getLabel().equals(name)) {
                        drawer.setVisible(visible);
                        break;
                    }
                    drawer = null;
                    ++j;
                }
                if (drawer == null) {
                    drawer = new PaletteDrawer(name);
                    drawer.setVisible(visible);
                    this.viewer.getPaletteRoot().add((PaletteEntry)drawer);
                }
                ++i2;
            }
            FuzzyXMLNode[] items = HTMLUtil.selectXPathNodes(doc.getDocumentElement(), "/palette/items/item");
            Object[] categories = this.getCategories();
            int i3 = 0;
            while (i3 < items.length) {
                FuzzyXMLElement item = (FuzzyXMLElement)items[i3];
                String name = item.getAttributeNode("name").getValue();
                String group = item.getAttributeNode("group").getValue();
                String text = item.getValue();
                if (Arrays.binarySearch(categories, group) < 0) {
                    this.addPaletteItem(group, new DefaultPaletteItem(name, HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_tag"), text));
                }
                ++i3;
            }
        }
        List entries = this.viewer.getPaletteRoot().getChildren();
        int i4 = 0;
        while (i4 < entries.size()) {
            PaletteDrawer group = (PaletteDrawer)entries.get(i4);
            if (Arrays.binarySearch(this.defaultCategories, group.getLabel()) < 0) {
                IPaletteItem[] items = this.getPaletteItems(group.getLabel());
                ArrayList<HTMLPaletteEntry> itemList = new ArrayList<HTMLPaletteEntry>();
                int j = 0;
                while (j < items.length) {
                    HTMLPaletteEntry entry = new HTMLPaletteEntry(items[j].getLabel(), null, items[j].getImageDescriptor());
                    this.tools.put(entry, items[j]);
                    itemList.add(entry);
                    ++j;
                }
                group.setChildren(itemList);
            }
            ++i4;
        }
        this.createToolBar();
    }

    private void addPaletteItem(String category, IPaletteItem item) {
        ArrayList list;
        if (this.items.get(category) == null) {
            list = new ArrayList();
            this.items.put(category, list);
        }
        list = (ArrayList)this.items.get(category);
        list.add(item);
    }

    private void updateCategory(String category, List items) {
        ArrayList list = (ArrayList)this.items.get(category);
        if (list != null) {
            list.clear();
        }
        List entries = this.viewer.getPaletteRoot().getChildren();
        PaletteDrawer group = null;
        int i = 0;
        while (i < entries.size()) {
            group = (PaletteDrawer)entries.get(i);
            if (group.getLabel().equals(category)) break;
            group = null;
            ++i;
        }
        if (group == null) {
            group = new PaletteDrawer(category);
            this.viewer.getPaletteRoot().add((PaletteEntry)group);
        }
        i = 0;
        while (i < items.size()) {
            Map map = (Map)items.get(i);
            this.addPaletteItem(category, new DefaultPaletteItem((String)map.get("name"), HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_tag"), (String)map.get("text")));
            ++i;
        }
        ArrayList<HTMLPaletteEntry> itemList = new ArrayList<HTMLPaletteEntry>();
        IPaletteItem[] newItems = this.getPaletteItems(category);
        int i2 = 0;
        while (i2 < newItems.length) {
            HTMLPaletteEntry entry = new HTMLPaletteEntry(newItems[i2].getLabel(), null, newItems[i2].getImageDescriptor());
            this.tools.put(entry, newItems[i2]);
            itemList.add(entry);
            ++i2;
        }
        group.setChildren(itemList);
    }

    private void removeCategory(String category) {
        this.items.remove(category);
        List entries = this.viewer.getPaletteRoot().getChildren();
        PaletteDrawer group = null;
        int i = 0;
        while (i < entries.size()) {
            group = (PaletteDrawer)entries.get(i);
            if (group.getLabel().equals(category)) {
                List children = group.getChildren();
                int j = 0;
                while (j < children.size()) {
                    this.tools.remove((PaletteEntry)children.get(j));
                    group.remove((PaletteEntry)children.get(j));
                    ++j;
                }
                this.viewer.getPaletteRoot().remove((PaletteEntry)group);
                break;
            }
            ++i;
        }
    }

    private IPaletteItem[] getPaletteItems(String category) {
        ArrayList list = (ArrayList)this.items.get(category);
        if (list == null) {
            return new IPaletteItem[0];
        }
        return list.toArray(new IPaletteItem[list.size()]);
    }

    private String[] getCategories() {
        return this.items.keySet().toArray(new String[0]);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private String getPreferenceXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<palette>");
        List entries = this.viewer.getPaletteRoot().getChildren();
        sb.append("<groups>");
        int i = 0;
        while (i < entries.size()) {
            PaletteDrawer group = (PaletteDrawer)entries.get(i);
            sb.append("<group name=\"" + HTMLUtil.escapeXML(group.getLabel()) + "\"" + " visible=\"" + HTMLUtil.escapeXML(String.valueOf(group.isVisible())) + "\" />");
            ++i;
        }
        sb.append("</groups>");
        sb.append("<items>");
        String[] categories = this.getCategories();
        int i2 = 0;
        while (i2 < categories.length) {
            if (Arrays.binarySearch(this.defaultCategories, categories[i2]) < 0) {
                IPaletteItem[] items = this.getPaletteItems(categories[i2]);
                int j = 0;
                while (j < items.length) {
                    sb.append("<item group=\"" + HTMLUtil.escapeXML(categories[i2]) + "\"" + " name=\"" + HTMLUtil.escapeXML(items[j].getLabel()) + "\">" + HTMLUtil.escapeXML(((DefaultPaletteItem)items[j]).getContent()) + "</item>");
                    ++j;
                }
            }
            ++i2;
        }
        sb.append("</items>");
        sb.append("</palette>");
        return sb.toString();
    }

    static /* synthetic */ String[] access$1(PaletteView paletteView) {
        return paletteView.defaultCategories;
    }

    static /* synthetic */ IPaletteItem[] access$2(PaletteView paletteView, String string) {
        return paletteView.getPaletteItems(string);
    }

    private class HTMLPaletteEntry
    extends ToolEntry {
        public HTMLPaletteEntry(String label, String shortDescription, ImageDescriptor icon) {
            super(label, shortDescription, icon, icon);
        }

        public Tool createTool() {
            return null;
        }
    }

    private class PaletteCustomizeDialog
    extends Dialog {
        private Table table;
        private Button add;
        private Button edit;
        private Button remove;
        private HashMap operations = new HashMap();

        public PaletteCustomizeDialog(Shell parentShell) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected void constrainShellSize() {
            this.getShell().setSize(300, 300);
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(HTMLPlugin.getResourceString("Dialog.PaletteConfig"));
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(2, false));
            container.setLayoutData((Object)new GridData(1808));
            this.table = new Table(container, 2080);
            this.table.setLayoutData((Object)new GridData(1808));
            List entries = PaletteView.this.viewer.getPaletteRoot().getChildren();
            int i = 0;
            while (i < entries.size()) {
                TableItem item = new TableItem(this.table, 16384);
                item.setText(((PaletteDrawer)entries.get(i)).getLabel());
                item.setChecked(((PaletteDrawer)entries.get(i)).isVisible());
                ++i;
            }
            this.table.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PaletteCustomizeDialog this$1;
                {
                    this.this$1 = paletteCustomizeDialog;
                }

                public void widgetSelected(SelectionEvent evt) {
                    TableItem[] items = PaletteCustomizeDialog.access$0(this.this$1).getSelection();
                    if (items.length == 0 || Arrays.binarySearch(PaletteView.access$1(PaletteCustomizeDialog.access$4(this.this$1)), items[0].getText()) >= 0) {
                        PaletteCustomizeDialog.access$1(this.this$1).setEnabled(false);
                        PaletteCustomizeDialog.access$2(this.this$1).setEnabled(false);
                    } else {
                        PaletteCustomizeDialog.access$1(this.this$1).setEnabled(true);
                        PaletteCustomizeDialog.access$2(this.this$1).setEnabled(true);
                    }
                }
            });
            Composite buttons = new Composite(container, 0);
            buttons.setLayout((Layout)new GridLayout());
            buttons.setLayoutData((Object)new GridData(2));
            this.add = new Button(buttons, 8);
            this.add.setText(HTMLPlugin.getResourceString("Button.AddGroup"));
            this.add.setLayoutData((Object)new GridData(768));
            this.add.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PaletteCustomizeDialog this$1;
                {
                    this.this$1 = paletteCustomizeDialog;
                }

                public void widgetSelected(SelectionEvent evt) {
                    PaletteGroupDialog dialog = PaletteCustomizeDialog.access$4(this.this$1).new PaletteGroupDialog(this.this$1.getShell());
                    if (dialog.open() == 0) {
                        TableItem item = new TableItem(PaletteCustomizeDialog.access$0(this.this$1), 0);
                        item.setText(dialog.getGroupName());
                        item.setChecked(true);
                        PaletteCustomizeDialog.access$3(this.this$1).put(dialog.getGroupName(), dialog.getPaletteItems());
                    }
                }
            });
            this.edit = new Button(buttons, 8);
            this.edit.setText(HTMLPlugin.getResourceString("Button.EditGroup"));
            this.edit.setLayoutData((Object)new GridData(768));
            this.edit.setEnabled(false);
            this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PaletteCustomizeDialog this$1;
                {
                    this.this$1 = paletteCustomizeDialog;
                }

                public void widgetSelected(SelectionEvent evt) {
                    TableItem[] items = PaletteCustomizeDialog.access$0(this.this$1).getSelection();
                    List<HashMap<K, V>> initItems = new ArrayList<E>();
                    V obj = PaletteCustomizeDialog.access$3(this.this$1).get(items[0].getText());
                    if (obj != null && obj instanceof List) {
                        initItems = (List)obj;
                    } else {
                        IPaletteItem[] paletteItems = PaletteView.access$2(PaletteCustomizeDialog.access$4(this.this$1), items[0].getText());
                        int i = 0;
                        while (i < paletteItems.length) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("name", paletteItems[i].getLabel());
                            map.put("text", ((DefaultPaletteItem)paletteItems[i]).getContent());
                            initItems.add(map);
                            ++i;
                        }
                    }
                    PaletteGroupDialog dialog = PaletteCustomizeDialog.access$4(this.this$1).new PaletteGroupDialog(this.this$1.getShell(), items[0].getText(), initItems);
                    if (dialog.open() == 0) {
                        items[0].setText(dialog.getGroupName());
                        PaletteCustomizeDialog.access$3(this.this$1).put(items[0].getText(), dialog.getPaletteItems());
                    }
                }
            });
            this.remove = new Button(buttons, 8);
            this.remove.setText(HTMLPlugin.getResourceString("Button.RemoveGroup"));
            this.remove.setLayoutData((Object)new GridData(768));
            this.remove.setEnabled(false);
            this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PaletteCustomizeDialog this$1;
                {
                    this.this$1 = paletteCustomizeDialog;
                }

                public void widgetSelected(SelectionEvent evt) {
                    TableItem[] items = PaletteCustomizeDialog.access$0(this.this$1).getSelection();
                    PaletteCustomizeDialog.access$3(this.this$1).put(items[0].getText(), "remove");
                    PaletteCustomizeDialog.access$0(this.this$1).remove(PaletteCustomizeDialog.access$0(this.this$1).getSelectionIndex());
                }
            });
            return container;
        }

        protected void okPressed() {
            Iterator ite = this.operations.keySet().iterator();
            while (ite.hasNext()) {
                String key = (String)ite.next();
                Object obj = this.operations.get(key);
                if (obj.equals("remove")) {
                    PaletteView.this.removeCategory(key);
                    continue;
                }
                PaletteView.this.updateCategory(key, (List)obj);
            }
            List entries = PaletteView.this.viewer.getPaletteRoot().getChildren();
            int i = 0;
            while (i < entries.size()) {
                ((PaletteDrawer)entries.get(i)).setVisible(this.table.getItem(i).getChecked());
                ++i;
            }
            IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
            store.setValue("_pref_palette_items", PaletteView.this.getPreferenceXML());
            super.okPressed();
        }

        static /* synthetic */ Table access$0(PaletteCustomizeDialog paletteCustomizeDialog) {
            return paletteCustomizeDialog.table;
        }

        static /* synthetic */ Button access$1(PaletteCustomizeDialog paletteCustomizeDialog) {
            return paletteCustomizeDialog.edit;
        }

        static /* synthetic */ Button access$2(PaletteCustomizeDialog paletteCustomizeDialog) {
            return paletteCustomizeDialog.remove;
        }

        static /* synthetic */ HashMap access$3(PaletteCustomizeDialog paletteCustomizeDialog) {
            return paletteCustomizeDialog.operations;
        }

        static /* synthetic */ PaletteView access$4(PaletteCustomizeDialog paletteCustomizeDialog) {
            return paletteCustomizeDialog.PaletteView.this;
        }
    }

    private class PaletteGroupDialog
    extends Dialog {
        private Text name;
        private Table table;
        private Button add;
        private Button addFromTLD;
        private Button edit;
        private Button remove;
        private String initialName = null;
        private List initialItems = null;
        private String inputedName = null;
        private List inputedItems = null;

        public PaletteGroupDialog(Shell parentShell) {
            this(parentShell, null, new ArrayList());
        }

        public PaletteGroupDialog(Shell parentShell, String name, List items) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.initialName = name;
            this.initialItems = items;
        }

        protected void constrainShellSize() {
            this.getShell().setSize(450, 350);
        }

        protected Control createDialogArea(Composite parent) {
            if (this.initialName == null) {
                this.getShell().setText(HTMLPlugin.getResourceString("Dialog.AddPaletteGroup"));
            } else {
                this.getShell().setText(HTMLPlugin.getResourceString("Dialog.EditPaletteGroup"));
            }
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(3, false));
            container.setLayoutData((Object)new GridData(1808));
            Label label = new Label(container, 0);
            label.setText(HTMLPlugin.getResourceString("Label.GroupName"));
            this.name = new Text(container, 2048);
            if (this.initialName != null) {
                this.name.setText(this.initialName);
                this.name.setEditable(false);
            }
            this.name.setLayoutData((Object)new GridData(768));
            label = new Label(container, 0);
            label = new Label(container, 0);
            label.setText(HTMLPlugin.getResourceString("Label.Items"));
            this.table = new Table(container, 67584);
            this.table.setLayoutData((Object)new GridData(1808));
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(true);
            this.table.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PaletteGroupDialog this$1;
                {
                    this.this$1 = paletteGroupDialog;
                }

                public void widgetSelected(SelectionEvent evt) {
                    TableItem[] items = PaletteGroupDialog.access$0(this.this$1).getSelection();
                    if (items.length == 0) {
                        PaletteGroupDialog.access$1(this.this$1).setEnabled(false);
                        PaletteGroupDialog.access$2(this.this$1).setEnabled(false);
                    } else {
                        PaletteGroupDialog.access$1(this.this$1).setEnabled(true);
                        PaletteGroupDialog.access$2(this.this$1).setEnabled(true);
                    }
                }
            });
            TableColumn col1 = new TableColumn(this.table, 16384);
            col1.setText(HTMLPlugin.getResourceString("Message.ItemName"));
            col1.setWidth(100);
            TableColumn col2 = new TableColumn(this.table, 16384);
            col2.setText(HTMLPlugin.getResourceString("Message.InsertText"));
            col2.setWidth(250);
            if (this.initialName != null) {
                int i = 0;
                while (i < this.initialItems.size()) {
                    Map map = (Map)this.initialItems.get(i);
                    TableItem item = new TableItem(this.table, 0);
                    item.setText(new String[]{(String)map.get("name"), (String)map.get("text")});
                    ++i;
                }
            }
            Composite buttons = new Composite(container, 0);
            buttons.setLayout((Layout)new GridLayout());
            buttons.setLayoutData((Object)new GridData(2));
            this.add = new Button(buttons, 8);
            this.add.setText(HTMLPlugin.getResourceString("Button.AddItem"));
            this.add.setLayoutData((Object)new GridData(768));
            this.add.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PaletteGroupDialog this$1;
                {
                    this.this$1 = paletteGroupDialog;
                }

                public void widgetSelected(SelectionEvent evt) {
                    PaletteItemDialog dialog = PaletteGroupDialog.access$3(this.this$1).new PaletteItemDialog(this.this$1.getShell());
                    if (dialog.open() == 0) {
                        String name = dialog.getItemName();
                        String text = dialog.getInsertText();
                        TableItem item = new TableItem(PaletteGroupDialog.access$0(this.this$1), 0);
                        item.setText(new String[]{name, text});
                    }
                }
            });
            this.addFromTLD = new Button(buttons, 8);
            this.addFromTLD.setText(HTMLPlugin.getResourceString("Button.AddFromTLD"));
            this.addFromTLD.setLayoutData((Object)new GridData(768));
            this.addFromTLD.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PaletteGroupDialog this$1;
                {
                    this.this$1 = paletteGroupDialog;
                }

                public void widgetSelected(SelectionEvent evt) {
                    FileDialog openDialog = new FileDialog(this.this$1.getShell(), 4096);
                    openDialog.setFilterExtensions(new String[]{"*.tld"});
                    String openFile = openDialog.open();
                    if (openFile != null) {
                        try {
                            SAXParserFactory spfactory = SAXParserFactory.newInstance();
                            spfactory.setValidating(false);
                            SAXParser parser = spfactory.newSAXParser();
                            XMLReader reader = parser.getXMLReader();
                            TLDSAXHandler handler = new TLDSAXHandler();
                            reader.setEntityResolver(new TLDResolver());
                            reader.setContentHandler(handler);
                            reader.parse(new InputSource(new FileInputStream(new File(openFile))));
                            List tagInfoList = handler.getResult();
                            int i = 0;
                            while (i < tagInfoList.size()) {
                                TagInfo info = (TagInfo)tagInfoList.get(i);
                                TableItem item = new TableItem(PaletteGroupDialog.access$0(this.this$1), 0);
                                StringBuffer sb = new StringBuffer();
                                sb.append("<").append(info.getTagName());
                                AttributeInfo[] attrs = info.getRequiredAttributeInfo();
                                int j = 0;
                                while (j < attrs.length) {
                                    sb.append(" ").append(attrs[j].getAttributeName()).append("=\"\"");
                                    ++j;
                                }
                                if (info.hasBody()) {
                                    sb.append("></").append(info.getTagName()).append(">");
                                } else {
                                    sb.append("/>");
                                }
                                item.setText(new String[]{info.getTagName(), sb.toString()});
                                ++i;
                            }
                        }
                        catch (Exception ex) {
                            HTMLPlugin.openAlertDialog(ex.getMessage());
                        }
                    }
                }
            });
            this.edit = new Button(buttons, 8);
            this.edit.setText(HTMLPlugin.getResourceString("Button.EditItem"));
            this.edit.setLayoutData((Object)new GridData(768));
            this.edit.setEnabled(false);
            this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PaletteGroupDialog this$1;
                {
                    this.this$1 = paletteGroupDialog;
                }

                public void widgetSelected(SelectionEvent evt) {
                    TableItem[] item = PaletteGroupDialog.access$0(this.this$1).getSelection();
                    PaletteItemDialog dialog = PaletteGroupDialog.access$3(this.this$1).new PaletteItemDialog(this.this$1.getShell(), item[0].getText(0), item[0].getText(1));
                    if (dialog.open() == 0) {
                        String name = dialog.getItemName();
                        String text = dialog.getInsertText();
                        item[0].setText(new String[]{name, text});
                    }
                }
            });
            this.remove = new Button(buttons, 8);
            this.remove.setText(HTMLPlugin.getResourceString("Button.RemoveItem"));
            this.remove.setLayoutData((Object)new GridData(768));
            this.remove.setEnabled(false);
            this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PaletteGroupDialog this$1;
                {
                    this.this$1 = paletteGroupDialog;
                }

                public void widgetSelected(SelectionEvent evt) {
                    PaletteGroupDialog.access$0(this.this$1).remove(PaletteGroupDialog.access$0(this.this$1).getSelectionIndices());
                }
            });
            return container;
        }

        protected void okPressed() {
            int i;
            if (this.name.getText().equals("")) {
                HTMLPlugin.openAlertDialog(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("Message.GroupName")}));
                return;
            }
            if (this.initialName == null) {
                String[] categories = PaletteView.this.getCategories();
                i = 0;
                while (i < categories.length) {
                    if (categories[i].equals(this.name.getText())) {
                        HTMLPlugin.openAlertDialog(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.AlreadyExists"), new String[]{this.name.getText()}));
                        return;
                    }
                    ++i;
                }
            }
            this.inputedName = this.name.getText();
            this.inputedItems = new ArrayList();
            TableItem[] items = this.table.getItems();
            i = 0;
            while (i < items.length) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", items[i].getText(0));
                map.put("text", items[i].getText(1));
                this.inputedItems.add(map);
                ++i;
            }
            super.okPressed();
        }

        public String getGroupName() {
            return this.inputedName;
        }

        public List getPaletteItems() {
            return this.inputedItems;
        }

        static /* synthetic */ Table access$0(PaletteGroupDialog paletteGroupDialog) {
            return paletteGroupDialog.table;
        }

        static /* synthetic */ Button access$1(PaletteGroupDialog paletteGroupDialog) {
            return paletteGroupDialog.edit;
        }

        static /* synthetic */ Button access$2(PaletteGroupDialog paletteGroupDialog) {
            return paletteGroupDialog.remove;
        }

        static /* synthetic */ PaletteView access$3(PaletteGroupDialog paletteGroupDialog) {
            return paletteGroupDialog.PaletteView.this;
        }
    }

    private class PaletteItemDialog
    extends Dialog {
        private Text itemName;
        private Text insertText;
        private String inputedName;
        private String inputedText;
        private String initialName;
        private String initialText;

        public PaletteItemDialog(Shell parentShell) {
            this(parentShell, null, null);
        }

        public PaletteItemDialog(Shell parentShell, String name, String text) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.initialName = name;
            this.initialText = text;
        }

        protected void constrainShellSize() {
            this.getShell().setSize(400, 180);
        }

        protected Control createDialogArea(Composite parent) {
            if (this.initialName == null) {
                this.getShell().setText(HTMLPlugin.getResourceString("Dialog.AddPaletteItem"));
            } else {
                this.getShell().setText(HTMLPlugin.getResourceString("Dialog.EditPaletteItem"));
            }
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(2, false));
            container.setLayoutData((Object)new GridData(1808));
            Label label = new Label(container, 0);
            label.setText(HTMLPlugin.getResourceString("Label.ItemName"));
            this.itemName = new Text(container, 2048);
            this.itemName.setLayoutData((Object)new GridData(768));
            if (this.initialName != null) {
                this.itemName.setText(this.initialName);
            }
            label = new Label(container, 0);
            label.setText(HTMLPlugin.getResourceString("Label.InsertText"));
            this.insertText = new Text(container, 2818);
            this.insertText.setLayoutData((Object)new GridData(1808));
            if (this.initialText != null) {
                this.insertText.setText(this.initialText);
            }
            return container;
        }

        protected void okPressed() {
            if (this.itemName.getText().equals("")) {
                HTMLPlugin.openAlertDialog(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("Message.ItemName")}));
                return;
            }
            if (this.insertText.getText().equals("")) {
                HTMLPlugin.openAlertDialog(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("Message.InsertText")}));
                return;
            }
            this.inputedName = this.itemName.getText();
            this.inputedText = this.insertText.getText();
            super.okPressed();
        }

        public String getItemName() {
            return this.inputedName;
        }

        public String getInsertText() {
            return this.inputedText;
        }
    }
}

