/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.util.List;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.XPath;
import org.eclipse.core.resources.IFile;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.TagInfo;
import tk.eclipse.plugin.htmleditor.editors.HTMLValidator;
import tk.eclipse.plugin.jspeditor.editors.JSPInfo;
import tk.eclipse.plugin.jspeditor.editors.TLDInfo;

public class JSPValidator
extends HTMLValidator {
    private JSPInfo info;

    public JSPValidator(IFile file) {
        super(file);
    }

    protected void validateDocument(FuzzyXMLDocument doc) {
        if (doc != null) {
            this.info = new JSPInfo(this.getFile(), this.getContent());
            this.validateElement((FuzzyXMLElement)XPath.selectSingleNode((FuzzyXMLElement)doc.getDocumentElement(), (String)"*"));
        }
    }

    private void validateElement(FuzzyXMLElement element) {
        String prefix;
        String[] dim;
        if (element.getName().indexOf(":") > 0 && (dim = element.getName().split(":")).length != 1 && !(prefix = dim[0]).equals("jsp")) {
            TLDInfo tld = this.getTLDInfo(prefix);
            if (tld == null) {
                this.addElementMarker(element, "Validation.NoTLD", prefix);
            } else {
                TagInfo tagInfo = this.getTagInfo(tld, element.getName());
                if (tagInfo == null) {
                    this.addElementMarker(element, "Validation.NoCustomTag", element.getName());
                }
                AttributeInfo[] attrs = tagInfo.getAttributeInfo();
                int k = 0;
                while (k < attrs.length) {
                    if (attrs[k].isRequired() && !element.hasAttribute(attrs[k].getAttributeName())) {
                        this.addElementMarker(element, "Validation.RequiredAttr", attrs[k].getAttributeName());
                    }
                    ++k;
                }
            }
        }
        FuzzyXMLNode[] nodes = element.getChildren();
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] instanceof FuzzyXMLElement) {
                this.validateElement((FuzzyXMLElement)nodes[i]);
            }
            ++i;
        }
    }

    private TLDInfo getTLDInfo(String prefix) {
        TLDInfo[] tlds = this.info.getTLDInfo();
        int i = 0;
        while (i < tlds.length) {
            if (tlds[i].getPrefix().equals(prefix)) {
                return tlds[i];
            }
            ++i;
        }
        return null;
    }

    private TagInfo getTagInfo(TLDInfo tld, String tagName) {
        List list = tld.getTagInfo();
        int j = 0;
        while (j < list.size()) {
            TagInfo tagInfo = (TagInfo)list.get(j);
            if (tagInfo.getTagName().equals(tagName)) {
                return tagInfo;
            }
            ++j;
        }
        return null;
    }

    private void addElementMarker(FuzzyXMLElement element, String key, String value) {
        String message = HTMLPlugin.createMessage(HTMLPlugin.getResourceString(key), new String[]{value});
        super.addMarker(element.getOffset() + 1, element.getName().length(), message);
    }
}

