/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResults;

public class Form
implements Serializable {
    protected String name = null;
    protected List lFields = new ArrayList();
    protected FastHashMap hFields = new FastHashMap();
    protected String inherit = null;
    private boolean processed = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addField(Field f) {
        this.lFields.add(f);
        this.hFields.put((Object)f.getKey(), (Object)f);
    }

    public List getFields() {
        return Collections.unmodifiableList(this.lFields);
    }

    public Field getField(String fieldName) {
        return (Field)this.hFields.get((Object)fieldName);
    }

    public boolean containsField(String fieldName) {
        return this.hFields.containsKey((Object)fieldName);
    }

    protected void process(Map globalConstants, Map constants, Map forms) {
        Form parent;
        if (this.isProcessed()) {
            return;
        }
        int n = 0;
        if (this.isExtending() && (parent = (Form)forms.get(this.inherit)) != null) {
            if (!parent.isProcessed()) {
                parent.process(constants, globalConstants, forms);
            }
            Iterator i = parent.getFields().iterator();
            while (i.hasNext()) {
                Field f = (Field)i.next();
                if (this.hFields.get((Object)f.getKey()) != null) continue;
                this.lFields.add(n, f);
                this.hFields.put((Object)f.getKey(), (Object)f);
                ++n;
            }
        }
        this.hFields.setFast(true);
        ListIterator i = this.lFields.listIterator(n);
        while (i.hasNext()) {
            Field f = (Field)i.next();
            f.process(globalConstants, constants);
        }
        this.processed = true;
    }

    public String toString() {
        StringBuffer results = new StringBuffer();
        results.append("Form: ");
        results.append(this.name);
        results.append("\n");
        Iterator i = this.lFields.iterator();
        while (i.hasNext()) {
            results.append("\tField: \n");
            results.append(i.next());
            results.append("\n");
        }
        return results.toString();
    }

    ValidatorResults validate(Map params, Map actions, int page) throws ValidatorException {
        ValidatorResults results = new ValidatorResults();
        params.put("org.apache.commons.validator.ValidatorResults", results);
        Iterator fields = this.lFields.iterator();
        while (fields.hasNext()) {
            Field field = (Field)fields.next();
            params.put("org.apache.commons.validator.Field", field);
            if (field.getPage() > page) continue;
            results.merge(field.validate(params, actions));
        }
        return results;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public String getExtends() {
        return this.inherit;
    }

    public void setExtends(String string) {
        this.inherit = string;
    }

    public boolean isExtending() {
        return this.inherit != null;
    }
}

