/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.validator.Form;

public class FormSet
implements Serializable {
    private boolean processed = false;
    private String language = null;
    private String country = null;
    private String variant = null;
    private Map forms = new HashMap();
    private Map constants = new HashMap();

    public boolean isProcessed() {
        return this.processed;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public void addConstant(String name, String value) {
        this.constants.put(name, value);
    }

    public void addForm(Form f) {
        this.forms.put(f.getName(), f);
    }

    public Form getForm(String formName) {
        return (Form)this.forms.get(formName);
    }

    public Map getForms() {
        return Collections.unmodifiableMap(this.forms);
    }

    synchronized void process(Map globalConstants) {
        Iterator i = this.forms.values().iterator();
        while (i.hasNext()) {
            Form f = (Form)i.next();
            f.process(globalConstants, this.constants, this.forms);
        }
        this.processed = true;
    }

    public String toString() {
        StringBuffer results = new StringBuffer();
        results.append("FormSet: language=");
        results.append(this.language);
        results.append("  country=");
        results.append(this.country);
        results.append("  variant=");
        results.append(this.variant);
        results.append("\n");
        Iterator i = this.getForms().values().iterator();
        while (i.hasNext()) {
            results.append("   ");
            results.append(i.next());
            results.append("\n");
        }
        return results.toString();
    }
}

