/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.editors;

import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.FuzzyXMLText;
import jp.aonir.fuzzyxml.event.FuzzyXMLModifyListener;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jsf.editors.MultiPageFacesConfigEditor;

public class FacesConfigOperation {
    private FuzzyXMLModifyListener listener;
    private MultiPageFacesConfigEditor editor;
    private boolean allowOperation = true;

    public FacesConfigOperation(MultiPageFacesConfigEditor editor, FuzzyXMLModifyListener listener) {
        this.listener = listener;
        this.editor = editor;
    }

    public void setAllowOperation(boolean allowOperation) {
        this.allowOperation = allowOperation;
    }

    public void addManagedBean() {
        if (!this.allowOperation) {
            return;
        }
        FuzzyXMLDocument doc = this.getDocument();
        FuzzyXMLElement root = (FuzzyXMLElement)doc.getDocumentElement().getChildren()[0];
        FuzzyXMLNode[] children = root.getChildren();
        FuzzyXMLNode before = null;
        boolean flag = false;
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof FuzzyXMLElement) {
                if (!flag && ((FuzzyXMLElement)children[i]).getName().equals("managed-bean")) {
                    flag = true;
                }
                if (flag && !((FuzzyXMLElement)children[i]).getName().equals("managed-bean")) {
                    before = children[i];
                    break;
                }
            }
            ++i;
        }
        FuzzyXMLElement bean = doc.createElement("managed-bean");
        if (before == null) {
            root.appendChild((FuzzyXMLNode)bean);
        } else {
            root.insertBefore((FuzzyXMLNode)bean, before);
        }
        bean.appendChild((FuzzyXMLNode)doc.createText("\n"));
        FuzzyXMLElement name = doc.createElement("managed-bean-name");
        bean.appendChild((FuzzyXMLNode)name);
        bean.appendChild((FuzzyXMLNode)doc.createText("\n"));
        FuzzyXMLElement clazz = doc.createElement("managed-bean-class");
        bean.appendChild((FuzzyXMLNode)clazz);
        bean.appendChild((FuzzyXMLNode)doc.createText("\n"));
        FuzzyXMLElement scope = doc.createElement("managed-bean-scope");
        bean.appendChild((FuzzyXMLNode)scope);
        bean.appendChild((FuzzyXMLNode)doc.createText("\n"));
        if (before == null) {
            root.appendChild((FuzzyXMLNode)doc.createText("\n"));
        } else {
            root.insertBefore((FuzzyXMLNode)doc.createText("\n"), before);
        }
    }

    public void removeManagedBean(int index) {
        if (!this.allowOperation) {
            return;
        }
        FuzzyXMLDocument doc = this.getDocument();
        FuzzyXMLElement root = (FuzzyXMLElement)doc.getDocumentElement().getChildren()[0];
        FuzzyXMLNode[] element = HTMLUtil.selectXPathNodes((FuzzyXMLElement)root, (String)"/managed-bean");
        root.removeChild(element[index]);
    }

    public void updateManagedBean(int index, String name, String clazz, String scope) {
        if (!this.allowOperation) {
            return;
        }
        FuzzyXMLDocument doc = this.getDocument();
        FuzzyXMLElement root = (FuzzyXMLElement)doc.getDocumentElement().getChildren()[0];
        FuzzyXMLNode[] element = HTMLUtil.selectXPathNodes((FuzzyXMLElement)root, (String)"/managed-bean");
        FuzzyXMLNode[] children = ((FuzzyXMLElement)element[index]).getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof FuzzyXMLElement) {
                FuzzyXMLText text;
                FuzzyXMLElement child = (FuzzyXMLElement)children[i];
                if (child.getName().equals("managed-bean-name")) {
                    this.removeChildren(child);
                    text = doc.createText(name);
                    child.appendChild((FuzzyXMLNode)text);
                }
                if (child.getName().equals("managed-bean-class")) {
                    this.removeChildren(child);
                    text = doc.createText(clazz);
                    child.appendChild((FuzzyXMLNode)text);
                }
                if (child.getName().equals("managed-bean-scope")) {
                    this.removeChildren(child);
                    text = doc.createText(scope);
                    child.appendChild((FuzzyXMLNode)text);
                }
            }
            ++i;
        }
    }

    public void removeNavigation(String fromViewId, String toViewId) {
        if (!this.allowOperation) {
            return;
        }
        FuzzyXMLDocument doc = this.getDocument();
        FuzzyXMLElement root = (FuzzyXMLElement)doc.getDocumentElement().getChildren()[0];
        FuzzyXMLNode rule = HTMLUtil.selectXPathNode((FuzzyXMLElement)root, (String)("/navigation-rule[from-view-id='" + fromViewId + "']"));
        FuzzyXMLNode node = HTMLUtil.selectXPathNode((FuzzyXMLElement)((FuzzyXMLElement)rule), (String)("/navigation-case[to-view-id='" + toViewId + "']"));
        ((FuzzyXMLElement)rule).removeChild(node);
    }

    public void addNavigation(String fromViewId, String toViewId, String fromOutCome, String fromAction) {
        if (!this.allowOperation) {
            return;
        }
        FuzzyXMLDocument doc = this.getDocument();
        FuzzyXMLElement root = (FuzzyXMLElement)doc.getDocumentElement().getChildren()[0];
        FuzzyXMLElement rule = (FuzzyXMLElement)HTMLUtil.selectXPathNode((FuzzyXMLElement)root, (String)("/navigation-rule[from-view-id='" + fromViewId + "']"));
        if (rule == null) {
            rule = doc.createElement("navigation-rule");
            FuzzyXMLNode[] children = root.getChildren();
            boolean flag1 = false;
            boolean flag2 = false;
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof FuzzyXMLElement) {
                    FuzzyXMLElement element = (FuzzyXMLElement)children[i];
                    if (element.getName().equals("navigation-rule")) {
                        flag1 = true;
                    } else if (flag1) {
                        root.insertBefore((FuzzyXMLNode)rule, (FuzzyXMLNode)element);
                        flag2 = true;
                        break;
                    }
                }
                ++i;
            }
            if (!flag2) {
                root.appendChild((FuzzyXMLNode)rule);
            }
            FuzzyXMLElement from = doc.createElement("from-view-id");
            rule.appendChild((FuzzyXMLNode)doc.createText("\n"));
            rule.appendChild((FuzzyXMLNode)from);
            from.appendChild((FuzzyXMLNode)doc.createText(fromViewId));
        }
        FuzzyXMLElement caze = doc.createElement("navigation-case");
        rule.appendChild((FuzzyXMLNode)doc.createText("\n"));
        rule.appendChild((FuzzyXMLNode)caze);
        rule.appendChild((FuzzyXMLNode)doc.createText("\n"));
        if (fromAction != null && !fromAction.equals("")) {
            FuzzyXMLElement action = doc.createElement("from-action");
            caze.appendChild((FuzzyXMLNode)doc.createText("\n"));
            caze.appendChild((FuzzyXMLNode)action);
            action.appendChild((FuzzyXMLNode)doc.createText(fromAction));
        }
        if (fromOutCome != null && !fromOutCome.equals("")) {
            FuzzyXMLElement outcome = doc.createElement("from-outcome");
            caze.appendChild((FuzzyXMLNode)doc.createText("\n"));
            caze.appendChild((FuzzyXMLNode)outcome);
            outcome.appendChild((FuzzyXMLNode)doc.createText(fromOutCome));
        }
        FuzzyXMLElement to = doc.createElement("to-view-id");
        caze.appendChild((FuzzyXMLNode)doc.createText("\n"));
        caze.appendChild((FuzzyXMLNode)to);
        caze.appendChild((FuzzyXMLNode)doc.createText("\n"));
        to.appendChild((FuzzyXMLNode)doc.createText(toViewId));
    }

    public void updateNavigation(String fromViewId, String toViewId, String fromOutCome, String fromAction) {
        if (!this.allowOperation) {
            return;
        }
        FuzzyXMLDocument doc = this.getDocument();
        FuzzyXMLElement root = (FuzzyXMLElement)doc.getDocumentElement().getChildren()[0];
        FuzzyXMLElement caze = (FuzzyXMLElement)HTMLUtil.selectXPathNode((FuzzyXMLElement)root, (String)("/navigation-rule[from-view-id='" + fromViewId + "']/navigation-case[to-view-id='" + toViewId + "']"));
        FuzzyXMLElement action = (FuzzyXMLElement)HTMLUtil.selectXPathNode((FuzzyXMLElement)caze, (String)"/from-action");
        if (fromAction != null && !fromAction.equals("")) {
            if (action == null) {
                action = doc.createElement("from-action");
                FuzzyXMLNode[] children = caze.getChildren();
                int i = 0;
                while (i < children.length) {
                    String name;
                    if (children[i] instanceof FuzzyXMLElement && ((name = ((FuzzyXMLElement)children[i]).getName()).equals("to-view-id") || name.equals("from-outcome"))) {
                        caze.insertBefore((FuzzyXMLNode)action, children[i]);
                        break;
                    }
                    ++i;
                }
                action.appendChild((FuzzyXMLNode)doc.createText(fromAction));
            } else {
                this.removeChildren(action);
                action.appendChild((FuzzyXMLNode)doc.createText(fromAction));
            }
        } else {
            caze.removeChild((FuzzyXMLNode)action);
        }
        FuzzyXMLElement outcome = (FuzzyXMLElement)HTMLUtil.selectXPathNode((FuzzyXMLElement)caze, (String)"/from-outcome");
        if (fromOutCome != null && !fromOutCome.equals("")) {
            if (outcome == null) {
                outcome = doc.createElement("from-outcome");
                FuzzyXMLNode[] children = caze.getChildren();
                int i = 0;
                while (i < children.length) {
                    String name;
                    if (children[i] instanceof FuzzyXMLElement && (name = ((FuzzyXMLElement)children[i]).getName()).equals("to-view-id")) {
                        caze.insertBefore((FuzzyXMLNode)outcome, children[i]);
                        break;
                    }
                    ++i;
                }
                outcome.appendChild((FuzzyXMLNode)doc.createText(fromOutCome));
            } else {
                this.removeChildren(outcome);
                outcome.appendChild((FuzzyXMLNode)doc.createText(fromOutCome));
            }
        } else {
            caze.removeChild((FuzzyXMLNode)outcome);
        }
    }

    public void updateNavigationPath(String oldPath, String newPath) {
        if (!this.allowOperation) {
            return;
        }
        FuzzyXMLDocument doc = this.getDocument();
        FuzzyXMLElement root = (FuzzyXMLElement)doc.getDocumentElement().getChildren()[0];
        FuzzyXMLNode[] nodes = HTMLUtil.selectXPathNodes((FuzzyXMLElement)root, (String)("/navigation-rule/from-view-id[text()='" + oldPath + "']"));
        int i = 0;
        while (i < nodes.length) {
            FuzzyXMLElement from = (FuzzyXMLElement)nodes[i];
            this.removeChildren(from);
            from.appendChild((FuzzyXMLNode)doc.createText(newPath));
            ++i;
        }
        nodes = HTMLUtil.selectXPathNodes((FuzzyXMLElement)root, (String)("/navigation-rule/navigation-case/to-view-id[text()='" + oldPath + "']"));
        i = 0;
        while (i < nodes.length) {
            FuzzyXMLElement to = (FuzzyXMLElement)nodes[i];
            this.removeChildren(to);
            to.appendChild((FuzzyXMLNode)doc.createText(newPath));
            ++i;
        }
    }

    private FuzzyXMLDocument getDocument() {
        FuzzyXMLDocument doc = new FuzzyXMLParser().parse(this.editor.getDocument().get());
        doc.addModifyListener(this.listener);
        return doc;
    }

    private void removeChildren(FuzzyXMLElement element) {
        FuzzyXMLNode[] delete = element.getChildren();
        int j = 0;
        while (j < delete.length) {
            element.removeChild(delete[j]);
            ++j;
        }
    }
}

