/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.editors.editparts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.tools.ConnectionEndpointTracker;
import tk.eclipse.plugin.jsf.editors.FacesConfigOperation;
import tk.eclipse.plugin.jsf.editors.editparts.AbstractNavigationConnectionEditPart;
import tk.eclipse.plugin.jsf.editors.models.AbstractConnectionModel;
import tk.eclipse.plugin.jsf.editors.models.ForwardModel;
import tk.eclipse.plugin.jsf.editors.models.PageModel;

public class ForwardEditPart
extends AbstractNavigationConnectionEditPart {
    private FacesConfigOperation operation;

    public ForwardEditPart(FacesConfigOperation operation) {
        new ConnectionEndpointTracker((ConnectionEditPart)this);
        this.operation = operation;
    }

    protected IFigure createFigure() {
        ForwardModel model = (ForwardModel)this.getModel();
        String name = "<navigation-case>";
        if (!model.getFromAction().equals("")) {
            name = model.getFromAction();
        } else if (!model.getFromOutcome().equals("")) {
            name = model.getFromOutcome();
        }
        LabelConnection connection = new LabelConnection();
        connection.setText(name);
        connection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        return connection;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String propName = evt.getPropertyName();
        ForwardModel model = (ForwardModel)this.getModel();
        String name = (String)evt.getNewValue();
        String fromViewId = ((PageModel)model.getSource()).getPath();
        String toViewId = ((PageModel)model.getTarget()).getPath();
        String action = model.getFromAction();
        String outcome = model.getFromOutcome();
        this.operation.updateNavigation(fromViewId, toViewId, outcome, action);
        if (propName.equals("__bend_point")) {
            this.refreshBendpoints();
            return;
        }
        if (propName.equals("__from_action")) {
            if (name.equals("")) {
                name = model.getFromOutcome().equals("") ? "<navigation-case>" : model.getFromOutcome();
            }
        } else if (propName.equals("__from_outcome")) {
            if (name.equals("")) {
                name = model.getFromAction().equals("") ? "<navigation-case>" : model.getFromAction();
            }
        } else {
            return;
        }
        LabelConnection connection = (LabelConnection)this.getFigure();
        connection.setText(name);
        this.refreshVisuals();
    }

    protected void refreshBendpoints() {
        List bendpoints = ((AbstractConnectionModel)this.getModel()).getBendpoints();
        ArrayList<AbsoluteBendpoint> constraint = new ArrayList<AbsoluteBendpoint>();
        int i = 0;
        while (i < bendpoints.size()) {
            constraint.add(new AbsoluteBendpoint((Point)bendpoints.get(i)));
            ++i;
        }
        this.getConnectionFigure().setRoutingConstraint(constraint);
    }

    protected void refreshVisuals() {
        this.refreshBendpoints();
        super.refreshVisuals();
    }

    private class LabelConnection
    extends PolylineConnection {
        private Label label = new Label();

        public LabelConnection() {
            this.add((IFigure)this.label, new ConnectionLocator((Connection)this, 4));
            this.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        }

        public void setText(String text) {
            this.label.setText(text);
        }
    }
}

