/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.template;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import tk.eclipse.plugin.jsf.template.CharsetTemplateVariable;
import tk.eclipse.plugin.jsf.template.MyFacesTemplateVariable;

public class TemplateFileCreator {
    private HashMap fResolvers = new HashMap();

    public TemplateFileCreator() {
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.WordSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.LineSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Dollar());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Date());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Year());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Time());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.User());
        this.addResolver((TemplateVariableResolver)new CharsetTemplateVariable());
        this.addResolver(new MyFacesTemplateVariable());
    }

    private void addResolver(TemplateVariableResolver resolver) {
        this.fResolvers.put(resolver.getType(), resolver);
    }

    public void create(IFile file, Template template, String charset, String myfacesTaglib, IProgressMonitor monitor) throws CoreException, BadLocationException, TemplateException {
        ByteArrayInputStream contents = new ByteArrayInputStream(this.getContent(template, charset, myfacesTaglib).getBytes());
        file.create((InputStream)contents, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    private String getContent(Template template, String charset, String myfacesTaglib) throws BadLocationException, TemplateException {
        DefaultContext context = new DefaultContext();
        context.setVariable("charset", charset);
        context.setVariable("myfaces_taglib", myfacesTaglib);
        TemplateBuffer buffer = context.evaluate(template);
        String content = buffer.getString();
        return content;
    }

    private void resolve(TemplateBuffer buffer, TemplateContext context) throws MalformedTreeException, BadLocationException {
        TemplateVariable[] variables = buffer.getVariables();
        List positions = TemplateFileCreator.variablesToPositions(variables);
        ArrayList<ReplaceEdit> edits = new ArrayList<ReplaceEdit>(5);
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            if (!variable.isUnambiguous()) {
                int[] oldOffsets = variable.getOffsets();
                int oldLength = variable.getLength();
                String oldValue = variable.getDefaultValue();
                String type = variable.getType();
                TemplateVariableResolver resolver = (TemplateVariableResolver)this.fResolvers.get(type);
                if (resolver == null) {
                    resolver = new DefaultResolver(type, "");
                }
                resolver.resolve(variable, context);
                String value = variable.getDefaultValue();
                if (!oldValue.equals(value)) {
                    int k = 0;
                    while (k != oldOffsets.length) {
                        edits.add(new ReplaceEdit(oldOffsets[k], oldLength, value));
                        ++k;
                    }
                }
            }
            ++i;
        }
        Document document = new Document(buffer.getString());
        MultiTextEdit edit = new MultiTextEdit(0, document.getLength());
        edit.addChildren(positions.toArray(new TextEdit[positions.size()]));
        edit.addChildren(edits.toArray(new TextEdit[edits.size()]));
        edit.apply((IDocument)document, 2);
        TemplateFileCreator.positionsToVariables(positions, variables);
        buffer.setContent(document.get(), variables);
    }

    private static List variablesToPositions(TemplateVariable[] variables) {
        ArrayList<RangeMarker> positions = new ArrayList<RangeMarker>(5);
        int i = 0;
        while (i != variables.length) {
            int[] offsets = variables[i].getOffsets();
            int j = 0;
            while (j != offsets.length) {
                positions.add(new RangeMarker(offsets[j], 0));
                ++j;
            }
            ++i;
        }
        return positions;
    }

    private static void positionsToVariables(List positions, TemplateVariable[] variables) {
        Iterator iterator = positions.iterator();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            int[] offsets = new int[variable.getOffsets().length];
            int j = 0;
            while (j != offsets.length) {
                offsets[j] = ((TextEdit)iterator.next()).getOffset();
                ++j;
            }
            variable.setOffsets(offsets);
            ++i;
        }
    }

    private class DefaultResolver
    extends TemplateVariableResolver {
        public DefaultResolver(String type, String description) {
            super(type, description);
        }
    }

    private class DefaultContext
    extends TemplateContext {
        public DefaultContext() {
            super(null);
        }

        public boolean canEvaluate(Template template) {
            return true;
        }

        public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
            TemplateTranslator translator = new TemplateTranslator();
            TemplateBuffer buffer = translator.translate(template);
            TemplateFileCreator.this.resolve(buffer, this);
            return buffer;
        }
    }
}

