/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert._MessageUtils;

public class BooleanConverter
implements Converter {
    private static final String CONVERSION_MESSAGE_ID = "javax.faces.convert.BooleanConverter.CONVERSION";
    public static final String CONVERTER_ID = "javax.faces.Boolean";

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value != null && (value = value.trim()).length() > 0) {
            try {
                return Boolean.valueOf(value);
            }
            catch (Exception e) {
                throw new ConverterException(_MessageUtils.getErrorMessage(facesContext, CONVERSION_MESSAGE_ID, new Object[]{value, uiComponent.getId()}), (Throwable)e);
            }
        }
        return null;
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        try {
            return ((Boolean)value).toString();
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }
}

