/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.selectOneCountry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.faces.component.UISelectItem;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.model.SelectItem;
import org.apache.myfaces.component.html.ext.HtmlSelectOneMenu;

public class SelectOneCountry
extends HtmlSelectOneMenu {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.SelectOneCountry";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.SelectOneCountryRenderer";
    private Integer _maxLength = null;

    public SelectOneCountry() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public Integer getMaxLength() {
        if (this._maxLength != null) {
            return this._maxLength;
        }
        ValueBinding vb = this.getValueBinding("length");
        return vb != null ? (Integer)vb.getValue(this.getFacesContext()) : null;
    }

    public void setMaxLength(Integer maxLength) {
        this._maxLength = maxLength;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._maxLength};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._maxLength = (Integer)values[1];
    }

    public void encodeChildren(FacesContext context) {
    }

    public int getChildCount() {
        return Locale.getISOCountries().length;
    }

    public List getChildren() {
        int maxDescriptionLength;
        String[] availableCountries = Locale.getISOCountries();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Locale currentLocale = viewRoot != null ? viewRoot.getLocale() : facesContext.getApplication().getDefaultLocale();
        TreeMap<String, String> map = new TreeMap<String, String>();
        int i = 0;
        while (i < availableCountries.length) {
            String countryCode = availableCountries[i];
            Locale tmp = new Locale(countryCode, countryCode);
            map.put(tmp.getDisplayCountry(currentLocale), countryCode);
            ++i;
        }
        ArrayList<UISelectItem> countriesSelectItems = new ArrayList<UISelectItem>(availableCountries.length);
        int n = maxDescriptionLength = this._maxLength == null ? Integer.MAX_VALUE : this._maxLength;
        if (maxDescriptionLength < 5) {
            maxDescriptionLength = 5;
        }
        Iterator i2 = map.keySet().iterator();
        while (i2.hasNext()) {
            String countryName = (String)i2.next();
            String countryCode = (String)map.get(countryName);
            String label = countryName.length() <= maxDescriptionLength ? countryName : countryName.substring(0, maxDescriptionLength - 3) + "...";
            UISelectItem selectItem = new UISelectItem();
            selectItem.setValue(new SelectItem(countryCode, label));
            countriesSelectItems.add(selectItem);
        }
        return countriesSelectItems;
    }
}

